/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.bestsolution;

import org.drools.planner.core.event.SolverEventSupport;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListenerAdapter;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestSolutionRecaller
extends SolverPhaseLifecycleListenerAdapter {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean assertBestScoreIsUnmodified = false;
    protected SolverEventSupport solverEventSupport;

    public void setAssertBestScoreIsUnmodified(boolean assertBestScoreIsUnmodified) {
        this.assertBestScoreIsUnmodified = assertBestScoreIsUnmodified;
    }

    public void setSolverEventSupport(SolverEventSupport solverEventSupport) {
        this.solverEventSupport = solverEventSupport;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        int uninitializedVariableCount = solverScope.getScoreDirector().countWorkingSolutionUninitializedVariables();
        solverScope.setBestUninitializedVariableCount(uninitializedVariableCount);
        Score score = solverScope.calculateScore();
        solverScope.setBestScore(score);
        solverScope.getBestSolution().setScore(score);
        if (uninitializedVariableCount == 0) {
            solverScope.setStartingInitializedScore(score);
        }
    }

    @Override
    public void stepEnded(AbstractStepScope stepScope) {
        if (stepScope.isBestSolutionCloningDelayed()) {
            return;
        }
        AbstractSolverPhaseScope phaseScope = stepScope.getPhaseScope();
        DefaultSolverScope solverScope = phaseScope.getSolverScope();
        int newUninitializedVariableCount = stepScope.getUninitializedVariableCount();
        Score newScore = stepScope.getScore();
        int bestUninitializedVariableCount = solverScope.getBestUninitializedVariableCount();
        Score bestScore = solverScope.getBestScore();
        boolean bestScoreImproved = newUninitializedVariableCount == bestUninitializedVariableCount ? newScore.compareTo(bestScore) > 0 : newUninitializedVariableCount < bestUninitializedVariableCount;
        stepScope.setBestScoreImproved(bestScoreImproved);
        if (bestScoreImproved) {
            phaseScope.setBestSolutionStepIndex(stepScope.getStepIndex());
            Solution newBestSolution = stepScope.createOrGetClonedSolution();
            this.updateBestSolution(solverScope, newBestSolution, newUninitializedVariableCount);
        } else if (this.assertBestScoreIsUnmodified) {
            solverScope.assertScore(solverScope.getBestSolution());
        }
    }

    public void updateBestSolution(DefaultSolverScope solverScope, Solution solution, int uninitializedVariableCount) {
        if (uninitializedVariableCount == 0) {
            if (!solverScope.isBestSolutionInitialized()) {
                solverScope.setStartingInitializedScore((Score)solution.getScore());
            }
        } else {
            solverScope.setStartingInitializedScore(null);
        }
        solverScope.setBestUninitializedVariableCount(uninitializedVariableCount);
        solverScope.setBestSolution(solution);
        solverScope.setBestScore((Score)solution.getScore());
        this.solverEventSupport.fireBestSolutionChanged(solution);
    }
}

