/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.bruteforce;

import org.drools.planner.core.bruteforce.BruteForceEntityWalker;
import org.drools.planner.core.bruteforce.BruteForceSolverPhase;
import org.drools.planner.core.bruteforce.event.BruteForceSolverPhaseLifecycleListener;
import org.drools.planner.core.bruteforce.scope.BruteForceSolverPhaseScope;
import org.drools.planner.core.bruteforce.scope.BruteForceStepScope;
import org.drools.planner.core.phase.AbstractSolverPhase;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

public class DefaultBruteForceSolverPhase
extends AbstractSolverPhase
implements BruteForceSolverPhase,
BruteForceSolverPhaseLifecycleListener {
    protected BruteForceEntityWalker bruteForceEntityWalker;

    public void setBruteForceEntityWalker(BruteForceEntityWalker bruteForceEntityWalker) {
        this.bruteForceEntityWalker = bruteForceEntityWalker;
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        BruteForceSolverPhaseScope bruteForceSolverPhaseScope = new BruteForceSolverPhaseScope(solverScope);
        this.phaseStarted(bruteForceSolverPhaseScope);
        BruteForceStepScope stepScope = this.createNextStepScope(bruteForceSolverPhaseScope, null);
        while (!this.termination.isPhaseTerminated(bruteForceSolverPhaseScope) && this.bruteForceEntityWalker.hasWalk()) {
            this.stepStarted(stepScope);
            this.bruteForceEntityWalker.walk();
            Score score = bruteForceSolverPhaseScope.calculateScore();
            stepScope.setScore(score);
            this.stepEnded(stepScope);
            stepScope = this.createNextStepScope(bruteForceSolverPhaseScope, stepScope);
        }
        this.phaseEnded(bruteForceSolverPhaseScope);
    }

    private BruteForceStepScope createNextStepScope(BruteForceSolverPhaseScope phaseScope, BruteForceStepScope completedStepScope) {
        if (completedStepScope == null) {
            completedStepScope = new BruteForceStepScope(phaseScope);
            completedStepScope.setScore(phaseScope.getStartingScore());
            completedStepScope.setStepIndex(-1);
        }
        phaseScope.setLastCompletedStepScope(completedStepScope);
        BruteForceStepScope stepScope = new BruteForceStepScope(phaseScope);
        stepScope.setStepIndex(completedStepScope.getStepIndex() + 1);
        return stepScope;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(BruteForceSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.bruteForceEntityWalker.phaseStarted(phaseScope);
    }

    public void stepStarted(BruteForceStepScope stepScope) {
        super.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(BruteForceStepScope stepScope) {
        super.stepEnded(stepScope);
        this.bruteForceEntityWalker.stepEnded(stepScope);
        BruteForceSolverPhaseScope bruteForceSolverPhaseScope = stepScope.getPhaseScope();
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpend = bruteForceSolverPhaseScope.calculateSolverTimeMillisSpend();
            this.logger.debug("    Step index ({}), time spend ({}), score ({}), {} best score ({}).", new Object[]{stepScope.getStepIndex(), timeMillisSpend, stepScope.getScore(), stepScope.getBestScoreImproved() != false ? "new" : "   ", bruteForceSolverPhaseScope.getBestScore()});
        }
    }

    @Override
    public void phaseEnded(BruteForceSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.bruteForceEntityWalker.phaseEnded(phaseScope);
        this.logger.info("Phase ({}) bruteForce ended: step total ({}), time spend ({}), best score ({}).", new Object[]{this.phaseIndex, phaseScope.getLastCompletedStepScope().getStepIndex() + 1, phaseScope.calculateSolverTimeMillisSpend(), phaseScope.getBestScore()});
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingEnded(solverScope);
    }
}

