/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.constructionheuristic;

import java.util.List;
import org.drools.planner.core.constructionheuristic.ConstructionHeuristicSolverPhase;
import org.drools.planner.core.constructionheuristic.placer.entity.EntityPlacer;
import org.drools.planner.core.constructionheuristic.scope.ConstructionHeuristicMoveScope;
import org.drools.planner.core.constructionheuristic.scope.ConstructionHeuristicSolverPhaseScope;
import org.drools.planner.core.constructionheuristic.scope.ConstructionHeuristicStepScope;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.AbstractSolverPhase;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

public class DefaultConstructionHeuristicSolverPhase
extends AbstractSolverPhase
implements ConstructionHeuristicSolverPhase {
    protected List<EntityPlacer> entityPlacerList;
    protected boolean assertStepScoreIsUncorrupted = false;

    public void setEntityPlacerList(List<EntityPlacer> entityPlacerList) {
        this.entityPlacerList = entityPlacerList;
    }

    public void setAssertStepScoreIsUncorrupted(boolean assertStepScoreIsUncorrupted) {
        this.assertStepScoreIsUncorrupted = assertStepScoreIsUncorrupted;
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        ConstructionHeuristicSolverPhaseScope phaseScope = new ConstructionHeuristicSolverPhaseScope(solverScope);
        this.phaseStarted(phaseScope);
        if (this.entityPlacerList.size() != 1) {
            throw new UnsupportedOperationException();
        }
        EntityPlacer entityPlacer = this.entityPlacerList.get(0);
        ConstructionHeuristicStepScope stepScope = this.createNextStepScope(phaseScope, null);
        while (!this.termination.isPhaseTerminated(phaseScope)) {
            this.stepStarted(stepScope);
            ConstructionHeuristicMoveScope moveScope = entityPlacer.nominateMove(stepScope);
            if (moveScope == null) break;
            Move step = moveScope.getMove();
            stepScope.setStep(step);
            if (this.logger.isDebugEnabled()) {
                stepScope.setStepString(step.toString());
            }
            stepScope.setUndoStep(moveScope.getUndoMove());
            stepScope.setScore(moveScope.getScore());
            this.doStep(stepScope);
            this.stepEnded(stepScope);
            stepScope = this.createNextStepScope(phaseScope, stepScope);
        }
        this.phaseEnded(phaseScope);
    }

    private ConstructionHeuristicStepScope createNextStepScope(ConstructionHeuristicSolverPhaseScope phaseScope, ConstructionHeuristicStepScope completedStepScope) {
        if (completedStepScope == null) {
            completedStepScope = new ConstructionHeuristicStepScope(phaseScope);
            completedStepScope.setScore(phaseScope.getStartingScore());
            completedStepScope.setStepIndex(-1);
        }
        phaseScope.setLastCompletedStepScope(completedStepScope);
        ConstructionHeuristicStepScope stepScope = new ConstructionHeuristicStepScope(phaseScope);
        stepScope.setStepIndex(completedStepScope.getStepIndex() + 1);
        return stepScope;
    }

    private void doStep(ConstructionHeuristicStepScope stepScope) {
        ConstructionHeuristicSolverPhaseScope phaseScope = stepScope.getPhaseScope();
        stepScope.getStep().doMove(stepScope.getScoreDirector());
        phaseScope.getWorkingSolution().setScore(stepScope.getScore());
        if (this.assertStepScoreIsUncorrupted) {
            phaseScope.assertWorkingScoreFromScratch(stepScope.getScore());
            phaseScope.assertExpectedWorkingScore(stepScope.getScore());
        }
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        for (EntityPlacer entityPlacer : this.entityPlacerList) {
            entityPlacer.solvingStarted(solverScope);
        }
    }

    public void phaseStarted(ConstructionHeuristicSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        for (EntityPlacer entityPlacer : this.entityPlacerList) {
            entityPlacer.phaseStarted(phaseScope);
        }
    }

    public void stepStarted(ConstructionHeuristicStepScope stepScope) {
        super.stepStarted(stepScope);
        for (EntityPlacer entityPlacer : this.entityPlacerList) {
            entityPlacer.stepStarted(stepScope);
        }
    }

    public void stepEnded(ConstructionHeuristicStepScope stepScope) {
        super.stepEnded(stepScope);
        for (EntityPlacer entityPlacer : this.entityPlacerList) {
            entityPlacer.stepEnded(stepScope);
        }
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpend = stepScope.getPhaseScope().calculateSolverTimeMillisSpend();
            this.logger.debug("    Step index ({}), time spend ({}), score ({}), selected move count ({}) for constructing step ({}).", new Object[]{stepScope.getStepIndex(), timeMillisSpend, stepScope.getScore(), stepScope.getSelectedMoveCount(), stepScope.getStepString()});
        }
    }

    public void phaseEnded(ConstructionHeuristicSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        Solution newBestSolution = phaseScope.getScoreDirector().cloneWorkingSolution();
        int newBestUninitializedVariableCount = phaseScope.getSolutionDescriptor().countUninitializedVariables(newBestSolution);
        this.bestSolutionRecaller.updateBestSolution(phaseScope.getSolverScope(), newBestSolution, newBestUninitializedVariableCount);
        for (EntityPlacer entityPlacer : this.entityPlacerList) {
            entityPlacer.phaseEnded(phaseScope);
        }
        this.logger.info("Phase ({}) constructionHeuristic ended: step total ({}), time spend ({}), best score ({}).", new Object[]{this.phaseIndex, phaseScope.getLastCompletedStepScope().getStepIndex() + 1, phaseScope.calculateSolverTimeMillisSpend(), phaseScope.getBestScore()});
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        for (EntityPlacer entityPlacer : this.entityPlacerList) {
            entityPlacer.solvingEnded(solverScope);
        }
    }
}

