/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.constructionheuristic.placer.entity;

import java.util.Iterator;
import java.util.List;
import org.drools.planner.core.constructionheuristic.placer.AbstractPlacer;
import org.drools.planner.core.constructionheuristic.placer.entity.EntityPlacer;
import org.drools.planner.core.constructionheuristic.placer.value.ValuePlacer;
import org.drools.planner.core.constructionheuristic.scope.ConstructionHeuristicMoveScope;
import org.drools.planner.core.constructionheuristic.scope.ConstructionHeuristicStepScope;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;

public class QueuedEntityPlacer
extends AbstractPlacer
implements EntityPlacer {
    protected final EntitySelector entitySelector;
    protected final List<ValuePlacer> valuePlacerList;
    protected Iterator<Object> entityIterator = null;
    protected Object nominatedEntity;
    protected Iterator<ValuePlacer> valuePlacerIterator;

    public QueuedEntityPlacer(EntitySelector entitySelector, List<ValuePlacer> valuePlacerList) {
        this.entitySelector = entitySelector;
        this.valuePlacerList = valuePlacerList;
        if (valuePlacerList.isEmpty()) {
            throw new IllegalArgumentException("The placer (" + this + ") with valuePlacerList (" + valuePlacerList + ") must have at least 1 valuePlacer.");
        }
        this.solverPhaseLifecycleSupport.addEventListener(entitySelector);
        for (ValuePlacer valuePlacer : valuePlacerList) {
            this.solverPhaseLifecycleSupport.addEventListener(valuePlacer);
        }
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope solverPhaseScope) {
        super.phaseStarted(solverPhaseScope);
        this.entityIterator = this.entitySelector.iterator();
        this.nominatedEntity = null;
        this.valuePlacerIterator = null;
    }

    @Override
    public ConstructionHeuristicMoveScope nominateMove(ConstructionHeuristicStepScope stepScope) {
        ConstructionHeuristicMoveScope nominatedMoveScope = null;
        while (nominatedMoveScope == null) {
            if (this.valuePlacerIterator == null || !this.valuePlacerIterator.hasNext()) {
                if (!this.entityIterator.hasNext()) {
                    return null;
                }
                this.nominatedEntity = this.entityIterator.next();
                this.valuePlacerIterator = this.valuePlacerList.iterator();
            }
            stepScope.setEntity(this.nominatedEntity);
            ValuePlacer valuePlacer = this.valuePlacerIterator.next();
            nominatedMoveScope = valuePlacer.nominateMove(stepScope);
        }
        return nominatedMoveScope;
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope solverPhaseScope) {
        super.phaseEnded(solverPhaseScope);
        this.entityIterator = null;
        this.nominatedEntity = null;
        this.valuePlacerIterator = null;
    }
}

