/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.common;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.drools.planner.core.domain.common.PropertyAccessor;

public final class ReflectionPropertyAccessor
implements PropertyAccessor {
    private final PropertyDescriptor propertyDescriptor;
    private final Method readMethod;
    private final Method writeMethod;

    public ReflectionPropertyAccessor(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
        this.readMethod = propertyDescriptor.getReadMethod();
        if (this.readMethod != null) {
            this.readMethod.setAccessible(true);
        }
        this.writeMethod = propertyDescriptor.getWriteMethod();
        if (this.writeMethod != null) {
            this.writeMethod.setAccessible(true);
        }
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    @Override
    public String getName() {
        return this.propertyDescriptor.getName();
    }

    @Override
    public Class<?> getPropertyType() {
        return this.propertyDescriptor.getPropertyType();
    }

    @Override
    public Object executeGetter(Object bean) {
        try {
            return this.readMethod.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot call property (" + this.propertyDescriptor.getName() + ") getter on bean of class (" + bean.getClass() + ").", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("The property (" + this.propertyDescriptor.getName() + ") getter on bean of class (" + bean.getClass() + ") throws an exception.", e.getCause());
        }
    }

    @Override
    public void executeSetter(Object bean, Object value) {
        try {
            this.writeMethod.invoke(bean, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot call property (" + this.propertyDescriptor.getName() + ") setter on bean of class (" + bean.getClass() + ").", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("The property (" + this.propertyDescriptor.getName() + ") setter on bean of class (" + bean.getClass() + ") throws an exception.", e.getCause());
        }
    }
}

