/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.drools.planner.core.domain.variable.PlanningValueSorter;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueSelectionOrder;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueSelectionPromotion;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListenerAdapter;
import org.drools.planner.core.score.director.ScoreDirector;

@Deprecated
public class PlanningValueSelector
extends SolverPhaseLifecycleListenerAdapter {
    private PlanningVariableDescriptor planningVariableDescriptor;
    private PlanningValueSelectionOrder selectionOrder = PlanningValueSelectionOrder.ORIGINAL;
    private PlanningValueSelectionPromotion selectionPromotion = PlanningValueSelectionPromotion.NONE;
    private boolean roundRobinSelection = false;
    private ScoreDirector scoreDirector;
    private Random workingRandom;
    private Collection<?> cachedPlanningValues = null;

    public PlanningValueSelector(PlanningVariableDescriptor planningVariableDescriptor) {
        this.planningVariableDescriptor = planningVariableDescriptor;
    }

    public void setSelectionOrder(PlanningValueSelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public void setSelectionPromotion(PlanningValueSelectionPromotion selectionPromotion) {
        this.selectionPromotion = selectionPromotion;
    }

    public void setRoundRobinSelection(boolean roundRobinSelection) {
        this.roundRobinSelection = roundRobinSelection;
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope phaseScope) {
        this.validate();
        this.scoreDirector = phaseScope.getScoreDirector();
        this.workingRandom = phaseScope.getWorkingRandom();
        this.initSelectedPlanningValueList(phaseScope);
    }

    private void validate() {
        PlanningValueSorter valueSorter;
        if (this.selectionOrder == PlanningValueSelectionOrder.INCREASING_STRENGTH && !(valueSorter = this.planningVariableDescriptor.getValueSorter()).isSortStrengthSupported()) {
            throw new IllegalStateException("The selectionOrder (" + (Object)((Object)this.selectionOrder) + ") can not be used on PlanningEntity (" + this.planningVariableDescriptor.getPlanningEntityDescriptor().getPlanningEntityClass().getName() + ")'s planningVariable (" + this.planningVariableDescriptor.getVariableName() + ") that has no support for strength sorting. Check the @PlanningVariable annotation.");
        }
    }

    private void initSelectedPlanningValueList(AbstractSolverPhaseScope phaseScope) {
        if (this.planningVariableDescriptor.isPlanningValuesCacheable()) {
            Collection<?> planningValues = this.planningVariableDescriptor.extractPlanningValues(phaseScope.getWorkingSolution(), null);
            this.cachedPlanningValues = this.applySelectionOrder(planningValues);
        } else {
            this.cachedPlanningValues = null;
        }
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope phaseScope) {
        this.cachedPlanningValues = null;
    }

    public Iterator<?> iterator(Object planningEntity) {
        if (this.cachedPlanningValues != null) {
            return this.cachedPlanningValues.iterator();
        }
        Collection<?> planningValues = this.planningVariableDescriptor.extractPlanningValues(this.scoreDirector.getWorkingSolution(), planningEntity);
        planningValues = this.applySelectionOrder(planningValues);
        return planningValues.iterator();
    }

    private Collection<?> applySelectionOrder(Collection<?> workingPlanningValues) {
        switch (this.selectionOrder) {
            case ORIGINAL: {
                return workingPlanningValues;
            }
            case RANDOM: {
                ArrayList randomPlanningValueList = new ArrayList(workingPlanningValues);
                Collections.shuffle(randomPlanningValueList, this.workingRandom);
                return randomPlanningValueList;
            }
            case INCREASING_STRENGTH: {
                ArrayList<Object> increasingStrengthPlanningValueList = new ArrayList<Object>(workingPlanningValues);
                PlanningValueSorter valueSorter = this.planningVariableDescriptor.getValueSorter();
                valueSorter.sortStrengthAscending(this.scoreDirector.getWorkingSolution(), increasingStrengthPlanningValueList);
                return increasingStrengthPlanningValueList;
            }
        }
        throw new IllegalStateException("The selectionOrder (" + (Object)((Object)this.selectionOrder) + ") is not implemented.");
    }
}

