/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.variable;

import java.util.Iterator;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.move.generic.ChangeMove;
import org.drools.planner.core.heuristic.selector.move.generic.chained.ChainedChangeMove;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueSelector;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

@Deprecated
public class PlanningValueWalker
implements SolverPhaseLifecycleListener {
    private final PlanningVariableDescriptor planningVariableDescriptor;
    private final PlanningValueSelector planningValueSelector;
    private ScoreDirector scoreDirector;
    private Object planningEntity;
    private Iterator<?> planningValueIterator;
    private boolean isFirstValue;
    private Object workingValue;

    public PlanningValueWalker(PlanningVariableDescriptor planningVariableDescriptor, PlanningValueSelector planningValueSelector) {
        this.planningVariableDescriptor = planningVariableDescriptor;
        this.planningValueSelector = planningValueSelector;
    }

    public PlanningVariableDescriptor getPlanningVariableDescriptor() {
        return this.planningVariableDescriptor;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        this.planningValueSelector.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope phaseScope) {
        this.planningValueSelector.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void stepStarted(AbstractStepScope stepScope) {
        this.planningValueSelector.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(AbstractStepScope stepScope) {
        this.planningValueSelector.stepEnded(stepScope);
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope phaseScope) {
        this.planningValueSelector.phaseEnded(phaseScope);
        this.scoreDirector = null;
        this.planningEntity = null;
        this.isFirstValue = false;
        this.workingValue = null;
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        this.planningValueSelector.solvingEnded(solverScope);
    }

    public void initWalk(Object planningEntity) {
        this.planningEntity = planningEntity;
        this.planningValueIterator = this.planningValueSelector.iterator(planningEntity);
        if (!this.planningValueIterator.hasNext()) {
            throw new IllegalStateException("The planningEntity (" + planningEntity + ") has a planning variable (" + this.planningVariableDescriptor.getVariableName() + ") which has no planning values.");
        }
        Object value = this.planningValueIterator.next();
        this.scoreDirector.beforeVariableChanged(planningEntity, this.planningVariableDescriptor.getVariableName());
        this.planningVariableDescriptor.setValue(planningEntity, value);
        this.scoreDirector.afterVariableChanged(planningEntity, this.planningVariableDescriptor.getVariableName());
        this.isFirstValue = true;
        this.workingValue = value;
    }

    public boolean hasWalk() {
        if (this.isFirstValue) {
            return true;
        }
        return this.planningValueIterator.hasNext();
    }

    public void walk() {
        if (this.isFirstValue) {
            this.isFirstValue = false;
        } else {
            Object value = this.planningValueIterator.next();
            this.changeWorkingValue(value);
        }
    }

    public void resetWalk() {
        this.planningValueIterator = this.planningValueSelector.iterator(this.planningEntity);
        Object value = this.planningValueIterator.next();
        this.changeWorkingValue(value);
        this.workingValue = value;
    }

    private void changeWorkingValue(Object value) {
        this.scoreDirector.beforeVariableChanged(this.planningEntity, this.planningVariableDescriptor.getVariableName());
        this.planningVariableDescriptor.setValue(this.planningEntity, value);
        this.scoreDirector.afterVariableChanged(this.planningEntity, this.planningVariableDescriptor.getVariableName());
        this.workingValue = value;
    }

    public Iterator<Move> moveIterator(Object planningEntity) {
        Iterator<?> planningValueIterator = this.planningValueSelector.iterator(planningEntity);
        if (!this.planningVariableDescriptor.isChained()) {
            return new ChangeMoveIterator(planningValueIterator, planningEntity);
        }
        return new ChainedChangeMoveIterator(planningValueIterator, planningEntity);
    }

    private class ChainedChangeMoveIterator
    extends ChangeMoveIterator {
        public ChainedChangeMoveIterator(Iterator<?> planningValueIterator, Object planningEntity) {
            super(planningValueIterator, planningEntity);
        }

        @Override
        public Move next() {
            Object toPlanningValue = this.planningValueIterator.next();
            return new ChainedChangeMove(this.planningEntity, PlanningValueWalker.this.planningVariableDescriptor, toPlanningValue);
        }
    }

    private class ChangeMoveIterator
    implements Iterator<Move> {
        protected final Iterator<?> planningValueIterator;
        protected final Object planningEntity;

        public ChangeMoveIterator(Iterator<?> planningValueIterator, Object planningEntity) {
            this.planningValueIterator = planningValueIterator;
            this.planningEntity = planningEntity;
        }

        @Override
        public boolean hasNext() {
            return this.planningValueIterator.hasNext();
        }

        @Override
        public Move next() {
            Object toPlanningValue = this.planningValueIterator.next();
            return new ChangeMove(this.planningEntity, PlanningValueWalker.this.planningVariableDescriptor, toPlanningValue);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

