/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor.lateacceptance;

import org.drools.planner.core.localsearch.decider.acceptor.AbstractAcceptor;
import org.drools.planner.core.localsearch.scope.LocalSearchMoveScope;
import org.drools.planner.core.localsearch.scope.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.scope.LocalSearchStepScope;
import org.drools.planner.core.score.Score;

public class LateAcceptanceAcceptor
extends AbstractAcceptor {
    protected int lateAcceptanceSize = -1;
    protected Score[] previousScores;
    protected int lateScoreIndex = -1;

    public void setLateAcceptanceSize(int lateAcceptanceSize) {
        this.lateAcceptanceSize = lateAcceptanceSize;
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.validate();
        this.previousScores = new Score[this.lateAcceptanceSize];
        Score initialScore = phaseScope.getBestScore();
        for (int i = 0; i < this.previousScores.length; ++i) {
            this.previousScores[i] = initialScore;
        }
        this.lateScoreIndex = 0;
    }

    private void validate() {
        if (this.lateAcceptanceSize <= 0) {
            throw new IllegalArgumentException("The lateAcceptanceSize (" + this.lateAcceptanceSize + ") cannot be negative or zero.");
        }
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.previousScores = null;
        this.lateScoreIndex = -1;
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope moveScope) {
        moveScope.getStepScope().getStepIndex();
        Score score = moveScope.getScore();
        Score lateScore = this.previousScores[this.lateScoreIndex];
        return score.compareTo(lateScore) >= 0;
    }

    @Override
    public void stepEnded(LocalSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        this.previousScores[this.lateScoreIndex] = stepScope.getScore();
        this.lateScoreIndex = (this.lateScoreIndex + 1) % this.lateAcceptanceSize;
    }
}

