/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.buildin.bendable;

import java.util.Arrays;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.bendable.BendableScore;
import org.drools.planner.core.score.buildin.bendable.BendableScoreHolder;
import org.drools.planner.core.score.definition.AbstractScoreDefinition;
import org.drools.planner.core.score.holder.ScoreHolder;

public class BendableScoreDefinition
extends AbstractScoreDefinition<BendableScore> {
    private final int hardLevelCount;
    private final int softLevelCount;
    private double recursiveTimeGradientWeight = 0.5;
    private BendableScore perfectMaximumScore = null;
    private BendableScore perfectMinimumScore = null;

    public BendableScoreDefinition(int hardLevelCount, int softLevelCount) {
        this.hardLevelCount = hardLevelCount;
        this.softLevelCount = softLevelCount;
    }

    public int getHardLevelCount() {
        return this.hardLevelCount;
    }

    public int getSoftLevelCount() {
        return this.softLevelCount;
    }

    public double getRecursiveTimeGradientWeight() {
        return this.recursiveTimeGradientWeight;
    }

    public void setRecursiveTimeGradientWeight(double recursiveTimeGradientWeight) {
        this.recursiveTimeGradientWeight = recursiveTimeGradientWeight;
        if (recursiveTimeGradientWeight < 0.0 || recursiveTimeGradientWeight > 1.0) {
            throw new IllegalArgumentException("Property recursiveTimeGradientWeight (" + recursiveTimeGradientWeight + ") must be greater or equal to 0.0 and smaller or equal to 1.0.");
        }
    }

    @Override
    public BendableScore getPerfectMaximumScore() {
        return this.perfectMaximumScore;
    }

    public void setPerfectMaximumScore(BendableScore perfectMaximumScore) {
        this.perfectMaximumScore = perfectMaximumScore;
    }

    @Override
    public BendableScore getPerfectMinimumScore() {
        return this.perfectMinimumScore;
    }

    public void setPerfectMinimumScore(BendableScore perfectMinimumScore) {
        this.perfectMinimumScore = perfectMinimumScore;
    }

    @Override
    public Class<BendableScore> getScoreClass() {
        return BendableScore.class;
    }

    @Override
    public Score parseScore(String scoreString) {
        return BendableScore.parseScore(this.hardLevelCount, this.softLevelCount, scoreString);
    }

    public BendableScore createScore(int ... scores) {
        int levelCount = this.hardLevelCount + this.softLevelCount;
        if (scores.length != levelCount) {
            throw new IllegalArgumentException("The scores (" + Arrays.toString(scores) + ")'s length (" + scores.length + ") is not levelCount (" + levelCount + ").");
        }
        return BendableScore.valueOf(Arrays.copyOfRange(scores, 0, this.hardLevelCount), Arrays.copyOfRange(scores, this.hardLevelCount, levelCount));
    }

    @Override
    public double calculateTimeGradient(BendableScore startScore, BendableScore endScore, BendableScore score) {
        startScore.validateCompatible(score);
        score.validateCompatible(endScore);
        if (score.compareTo(endScore) > 0) {
            return 1.0;
        }
        if (score.compareTo(startScore) < 0) {
            return 0.0;
        }
        double timeGradient = 0.0;
        double levelTimeGradientWeight = 1.0;
        int levelCount = this.hardLevelCount + this.softLevelCount;
        for (int i = 0; i < levelCount; ++i) {
            int scoreLevel;
            if (i != levelCount - 1) {
                levelTimeGradientWeight *= this.recursiveTimeGradientWeight;
            }
            int startScoreLevel = i < this.hardLevelCount ? startScore.getHardScore(i) : startScore.getSoftScore(i);
            int endScoreLevel = i < this.hardLevelCount ? endScore.getHardScore(i) : endScore.getSoftScore(i);
            int n = scoreLevel = i < this.hardLevelCount ? score.getHardScore(i) : score.getSoftScore(i);
            if (scoreLevel >= endScoreLevel) {
                timeGradient += levelTimeGradientWeight;
                continue;
            }
            if (scoreLevel <= startScoreLevel) continue;
            int levelTotal = endScoreLevel - startScoreLevel;
            int levelDelta = scoreLevel - startScoreLevel;
            double levelTimeGradient = (double)levelDelta / (double)levelTotal;
            timeGradient += levelTimeGradient * levelTimeGradientWeight;
        }
        if (timeGradient > 1.0) {
            timeGradient = 1.0;
        }
        return timeGradient;
    }

    @Override
    public ScoreHolder buildScoreHolder() {
        return new BendableScoreHolder(this.hardLevelCount, this.softLevelCount);
    }
}

