/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.buildin.bendable;

import java.util.Arrays;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.bendable.BendableScore;
import org.drools.planner.core.score.holder.AbstractScoreHolder;
import org.kie.event.rule.ActivationUnMatchListener;
import org.kie.runtime.rule.Match;
import org.kie.runtime.rule.RuleContext;
import org.kie.runtime.rule.Session;

public class BendableScoreHolder
extends AbstractScoreHolder {
    private int[] hardScores;
    private int[] softScores;

    public BendableScoreHolder(int hardLevelCount, int softLevelCount) {
        this.hardScores = new int[hardLevelCount];
        this.softScores = new int[softLevelCount];
    }

    public int getHardLevelCount() {
        return this.hardScores.length;
    }

    public int getHardScore(int hardLevel) {
        return this.hardScores[hardLevel];
    }

    public void setHardScore(int hardLevel, int hardScore) {
        this.hardScores[hardLevel] = hardScore;
    }

    public int getSoftLevelCount() {
        return this.softScores.length;
    }

    public int getSoftScore(int softLevel) {
        return this.softScores[softLevel];
    }

    public void setSoftScore(int softLevel, int softScore) {
        this.softScores[softLevel] = softScore;
    }

    public void addHardConstraintMatch(RuleContext kcontext, final int hardLevel, final int weight) {
        int n = hardLevel;
        this.hardScores[n] = this.hardScores[n] + weight;
        this.registerUndoListener(kcontext, new ActivationUnMatchListener(){

            public void unMatch(Session workingMemory, Match activation) {
                int[] nArray = BendableScoreHolder.this.hardScores;
                int n = hardLevel;
                nArray[n] = nArray[n] - weight;
            }
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, final int softLevel, final int weight) {
        int n = softLevel;
        this.softScores[n] = this.softScores[n] + weight;
        this.registerUndoListener(kcontext, new ActivationUnMatchListener(){

            public void unMatch(Session workingMemory, Match activation) {
                int[] nArray = BendableScoreHolder.this.softScores;
                int n = softLevel;
                nArray[n] = nArray[n] - weight;
            }
        });
    }

    @Override
    public Score extractScore() {
        return new BendableScore(Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }
}

