/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.buildin.hardsoft;

import org.drools.planner.core.score.AbstractScore;
import org.drools.planner.core.score.FeasibilityScore;

public final class HardSoftScore
extends AbstractScore<HardSoftScore>
implements FeasibilityScore<HardSoftScore> {
    private static final String HARD_LABEL = "hard";
    private static final String SOFT_LABEL = "soft";
    private final int hardScore;
    private final int softScore;

    public static HardSoftScore parseScore(String scoreString) {
        String[] levelStrings = HardSoftScore.parseLevelStrings(scoreString, HARD_LABEL, SOFT_LABEL);
        int hardScore = Integer.parseInt(levelStrings[0]);
        int softScore = Integer.parseInt(levelStrings[1]);
        return HardSoftScore.valueOf(hardScore, softScore);
    }

    public static HardSoftScore valueOf(int hardScore, int softScore) {
        return new HardSoftScore(hardScore, softScore);
    }

    private HardSoftScore(int hardScore, int softScore) {
        this.hardScore = hardScore;
        this.softScore = softScore;
    }

    public int getHardScore() {
        return this.hardScore;
    }

    public int getSoftScore() {
        return this.softScore;
    }

    @Override
    public boolean isFeasible() {
        return this.getHardScore() >= 0;
    }

    @Override
    public HardSoftScore add(HardSoftScore augment) {
        return new HardSoftScore(this.hardScore + augment.getHardScore(), this.softScore + augment.getSoftScore());
    }

    @Override
    public HardSoftScore subtract(HardSoftScore subtrahend) {
        return new HardSoftScore(this.hardScore - subtrahend.getHardScore(), this.softScore - subtrahend.getSoftScore());
    }

    @Override
    public HardSoftScore multiply(double multiplicand) {
        return new HardSoftScore((int)Math.floor((double)this.hardScore * multiplicand), (int)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public HardSoftScore divide(double divisor) {
        return new HardSoftScore((int)Math.floor((double)this.hardScore / divisor), (int)Math.floor((double)this.softScore / divisor));
    }

    @Override
    public double[] toDoubleLevels() {
        return new double[]{this.hardScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardSoftScore) {
            HardSoftScore other = (HardSoftScore)o;
            return this.hardScore == other.getHardScore() && this.softScore == other.getSoftScore();
        }
        return false;
    }

    public int hashCode() {
        return (629 + this.hardScore) * 37 + this.softScore;
    }

    @Override
    public int compareTo(HardSoftScore other) {
        if (this.hardScore != other.getHardScore()) {
            if (this.hardScore < other.getHardScore()) {
                return -1;
            }
            return 1;
        }
        if (this.softScore < other.getSoftScore()) {
            return -1;
        }
        if (this.softScore > other.getSoftScore()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.hardScore + HARD_LABEL + "/" + this.softScore + SOFT_LABEL;
    }
}

