/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.buildin.hardsoftbigdecimal;

import java.math.BigDecimal;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.drools.planner.core.score.holder.AbstractScoreHolder;
import org.kie.event.rule.ActivationUnMatchListener;
import org.kie.runtime.rule.Match;
import org.kie.runtime.rule.RuleContext;
import org.kie.runtime.rule.Session;

public class HardSoftBigDecimalScoreHolder
extends AbstractScoreHolder {
    protected BigDecimal hardScore;
    protected BigDecimal softScore;

    public BigDecimal getHardScore() {
        return this.hardScore;
    }

    public void setHardScore(BigDecimal hardScore) {
        this.hardScore = hardScore;
    }

    public BigDecimal getSoftScore() {
        return this.softScore;
    }

    public void setSoftScore(BigDecimal softScore) {
        this.softScore = softScore;
    }

    public void addHardConstraintMatch(RuleContext kcontext, final BigDecimal weight) {
        this.hardScore = this.hardScore.add(weight);
        this.registerUndoListener(kcontext, new ActivationUnMatchListener(){

            public void unMatch(Session workingMemory, Match activation) {
                HardSoftBigDecimalScoreHolder.this.hardScore = HardSoftBigDecimalScoreHolder.this.hardScore.subtract(weight);
            }
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, final BigDecimal weight) {
        this.softScore = this.softScore.add(weight);
        this.registerUndoListener(kcontext, new ActivationUnMatchListener(){

            public void unMatch(Session workingMemory, Match activation) {
                HardSoftBigDecimalScoreHolder.this.softScore = HardSoftBigDecimalScoreHolder.this.softScore.subtract(weight);
            }
        });
    }

    @Override
    public Score extractScore() {
        return HardSoftBigDecimalScore.valueOf(this.hardScore, this.softScore);
    }
}

