/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.buildin.simpledouble;

import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.simpledouble.SimpleDoubleScore;
import org.drools.planner.core.score.buildin.simpledouble.SimpleDoubleScoreHolder;
import org.drools.planner.core.score.definition.AbstractScoreDefinition;
import org.drools.planner.core.score.holder.ScoreHolder;

public class SimpleDoubleScoreDefinition
extends AbstractScoreDefinition<SimpleDoubleScore> {
    private SimpleDoubleScore perfectMaximumScore = SimpleDoubleScore.valueOf(0.0);
    private SimpleDoubleScore perfectMinimumScore = SimpleDoubleScore.valueOf(-1.7976931348623157E308);

    @Override
    public SimpleDoubleScore getPerfectMaximumScore() {
        return this.perfectMaximumScore;
    }

    public void setPerfectMaximumScore(SimpleDoubleScore perfectMaximumScore) {
        this.perfectMaximumScore = perfectMaximumScore;
    }

    @Override
    public SimpleDoubleScore getPerfectMinimumScore() {
        return this.perfectMinimumScore;
    }

    public void setPerfectMinimumScore(SimpleDoubleScore perfectMinimumScore) {
        this.perfectMinimumScore = perfectMinimumScore;
    }

    @Override
    public Class<SimpleDoubleScore> getScoreClass() {
        return SimpleDoubleScore.class;
    }

    @Override
    public Score parseScore(String scoreString) {
        return SimpleDoubleScore.parseScore(scoreString);
    }

    @Override
    public double calculateTimeGradient(SimpleDoubleScore startScore, SimpleDoubleScore endScore, SimpleDoubleScore score) {
        if (score.getScore() >= endScore.getScore()) {
            return 1.0;
        }
        if (startScore.getScore() >= score.getScore()) {
            return 0.0;
        }
        double scoreTotal = endScore.getScore() - startScore.getScore();
        double scoreDelta = score.getScore() - startScore.getScore();
        return scoreDelta / scoreTotal;
    }

    @Override
    public ScoreHolder buildScoreHolder() {
        return new SimpleDoubleScoreHolder();
    }
}

