/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.buildin.simplelong;

import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.simplelong.SimpleLongScore;
import org.drools.planner.core.score.buildin.simplelong.SimpleLongScoreHolder;
import org.drools.planner.core.score.definition.AbstractScoreDefinition;
import org.drools.planner.core.score.holder.ScoreHolder;

public class SimpleLongScoreDefinition
extends AbstractScoreDefinition<SimpleLongScore> {
    private SimpleLongScore perfectMaximumScore = SimpleLongScore.valueOf(0L);
    private SimpleLongScore perfectMinimumScore = SimpleLongScore.valueOf(Long.MIN_VALUE);

    @Override
    public SimpleLongScore getPerfectMaximumScore() {
        return this.perfectMaximumScore;
    }

    public void setPerfectMaximumScore(SimpleLongScore perfectMaximumScore) {
        this.perfectMaximumScore = perfectMaximumScore;
    }

    @Override
    public SimpleLongScore getPerfectMinimumScore() {
        return this.perfectMinimumScore;
    }

    public void setPerfectMinimumScore(SimpleLongScore perfectMinimumScore) {
        this.perfectMinimumScore = perfectMinimumScore;
    }

    @Override
    public Class<SimpleLongScore> getScoreClass() {
        return SimpleLongScore.class;
    }

    @Override
    public Score parseScore(String scoreString) {
        return SimpleLongScore.parseScore(scoreString);
    }

    @Override
    public double calculateTimeGradient(SimpleLongScore startScore, SimpleLongScore endScore, SimpleLongScore score) {
        if (score.getScore() >= endScore.getScore()) {
            return 1.0;
        }
        if (startScore.getScore() >= score.getScore()) {
            return 0.0;
        }
        long scoreTotal = endScore.getScore() - startScore.getScore();
        long scoreDelta = score.getScore() - startScore.getScore();
        return (double)scoreDelta / (double)scoreTotal;
    }

    @Override
    public ScoreHolder buildScoreHolder() {
        return new SimpleLongScoreHolder();
    }
}

