/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.rest;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.kie.processmigration.model.ProcessInfo;
import org.kie.processmigration.model.exceptions.InvalidKieServerException;
import org.kie.processmigration.model.exceptions.ProcessDefinitionNotFoundException;
import org.kie.processmigration.service.KieService;

@Path(value="/kieserver")
@Produces(value={"application/json"})
public class KieServiceResource {
    private static final String DEFAULT_PAGE = "0";
    private static final String DEFAULT_PAGE_SIZE = "1000";
    @Inject
    KieService kieService;

    @GET
    public Response getKieServers() {
        return Response.ok((Object)this.kieService.getConfigs()).build();
    }

    @GET
    @Path(value="/{kieServerId}/definitions/{containerId}/{processId}")
    public Response getDefinition(@PathParam(value="kieServerId") String kieServerId, @PathParam(value="containerId") String containerId, @PathParam(value="processId") String processId) throws InvalidKieServerException {
        try {
            ProcessInfo definition = this.kieService.getDefinition(kieServerId, containerId, processId);
            return Response.ok((Object)definition).build();
        }
        catch (ProcessDefinitionNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/instances")
    public Response getRunningInstances(@QueryParam(value="containerId") String containerId, @QueryParam(value="kieServerId") String kieServerId, @DefaultValue(value="0") @QueryParam(value="page") Integer page, @DefaultValue(value="1000") @QueryParam(value="pageSize") Integer pageSize) throws InvalidKieServerException {
        List result = this.kieService.getRunningInstances(containerId, kieServerId, page, pageSize);
        return Response.ok((Object)result).build();
    }
}

