/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.kie.processmigration.model.Plan;
import org.kie.processmigration.model.exceptions.PlanNotFoundException;
import org.kie.processmigration.service.PlanService;

@Path(value="/plans")
@Api(value="Plans")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class PlanResource {
    @Inject
    private PlanService planService;

    @GET
    @ApiOperation(value="Get all existing Migration plans")
    public Response findAll() {
        return Response.ok((Object)this.planService.findAll()).build();
    }

    @GET
    @Path(value="/{id}")
    @ApiOperation(value="Finds a migration plan by the given plan Id")
    public Response get(@ApiParam(value="Plan Id") @PathParam(value="id") Long id) throws PlanNotFoundException {
        return Response.ok((Object)this.planService.get(id)).build();
    }

    @POST
    @ApiOperation(value="Create a migration plan")
    public Response create(@ApiParam(value="Plan") Plan plan) {
        if (plan.getId() != 0L) {
            throw new IllegalArgumentException("The plan ID must not be provided when creating a new plan");
        }
        return Response.ok((Object)this.planService.create(plan)).build();
    }

    @PUT
    @Path(value="/{id}")
    @ApiOperation(value="Save a migration plan")
    public Response save(@ApiParam(value="Plan Id to update") @PathParam(value="id") Long id, @ApiParam(value="Plan") Plan plan) throws PlanNotFoundException {
        return Response.ok((Object)this.planService.update(id, plan)).build();
    }

    @DELETE
    @Path(value="/{id}")
    @ApiOperation(value="Delete an existing migration plan")
    public Response delete(@ApiParam(value="Plan Id to update") @PathParam(value="id") Long id) throws PlanNotFoundException {
        return Response.ok((Object)this.planService.delete(id)).build();
    }
}

