/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.kie.processmigration.model.KieServerConfig;
import org.kie.processmigration.model.ProcessInfo;
import org.kie.processmigration.model.RunningInstance;
import org.kie.processmigration.model.exceptions.InvalidKieServerException;
import org.kie.processmigration.model.exceptions.ProcessDefinitionNotFoundException;
import org.kie.processmigration.service.KieService;
import org.kie.processmigration.service.impl.KieServiceImpl;
import org.kie.server.api.exception.KieServicesHttpException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.definition.NodeDefinition;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.client.CredentialsProvider;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.UIServicesClient;
import org.kie.server.client.admin.ProcessAdminServicesClient;
import org.kie.server.client.credentials.EnteredCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.swarm.spi.api.config.ConfigKey;
import org.wildfly.swarm.spi.api.config.ConfigView;
import org.wildfly.swarm.spi.api.config.SimpleKey;

@ApplicationScoped
@Startup
public class KieServiceImpl
implements KieService {
    private static final String HOST = "host";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final long CONFIGURATION_TIMEOUT = 60000L;
    private static final long AWAIT_EXECUTOR = 5L;
    private static final long RETRY_DELAY = 2L;
    private static final Logger logger = LoggerFactory.getLogger(KieServiceImpl.class);
    final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    final Map<String, KieServerConfig> configs = new HashMap();
    final ConfigKey kieServersKey = new SimpleKey("kieservers");
    @Inject
    ConfigView configView;

    @PostConstruct
    public void loadConfigs() {
        if (this.configView.hasKeyOrSubkeys(this.kieServersKey)) {
            List value = (List)this.configView.resolve(this.kieServersKey).as(List.class).getValue();
            value.stream().forEach(arg_0 -> this.loadConfig(arg_0));
        }
    }

    @PreDestroy
    public void shutdown() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
        }
    }

    public Collection<KieServerConfig> getConfigs() {
        return Collections.unmodifiableCollection(this.configs.values());
    }

    public boolean hasKieServer(String kieServerId) {
        return this.configs.values().stream().anyMatch(config -> config.getId() != null && config.getId().equals(kieServerId));
    }

    public ProcessAdminServicesClient getProcessAdminServicesClient(String kieServerId) throws InvalidKieServerException {
        return (ProcessAdminServicesClient)this.getClient(kieServerId).getServicesClient(ProcessAdminServicesClient.class);
    }

    public QueryServicesClient getQueryServicesClient(String kieServerId) throws InvalidKieServerException {
        return (QueryServicesClient)this.getClient(kieServerId).getServicesClient(QueryServicesClient.class);
    }

    public List<RunningInstance> getRunningInstances(String containerId, String kieServerId, Integer page, Integer pageSize) throws InvalidKieServerException {
        ProcessServicesClient processServicesClient = this.getProcessServicesClient(kieServerId);
        List instanceList = processServicesClient.findProcessInstances(containerId, page, pageSize);
        int i = 0;
        ArrayList<RunningInstance> result = new ArrayList<RunningInstance>();
        for (ProcessInstance instance : instanceList) {
            result.add(new RunningInstance(++i, instance));
        }
        return result;
    }

    public boolean existsProcessDefinition(String containerId, String processId, String kieServerId) throws InvalidKieServerException {
        QueryServicesClient queryService = this.getQueryServicesClient(kieServerId);
        return queryService.findProcessByContainerIdProcessId(containerId, processId) != null;
    }

    public ProcessInfo getDefinition(String kieServerId, String containerId, String processId) throws ProcessDefinitionNotFoundException, InvalidKieServerException {
        String svgFile;
        ProcessInfo processInfo = new ProcessInfo();
        try {
            svgFile = this.getUIServicesClient(kieServerId).getProcessImage(containerId, processId);
        }
        catch (KieServicesHttpException e) {
            if (Response.Status.NOT_FOUND.getStatusCode() == e.getHttpCode().intValue()) {
                logger.debug("Process definition {}:{} not found in {}", new Object[]{containerId, processId, kieServerId});
                throw new ProcessDefinitionNotFoundException(kieServerId, containerId, processId);
            }
            logger.warn("Unable to fetch SVG file from {}", (Object)kieServerId, (Object)e);
            throw e;
        }
        svgFile = svgFile.replaceAll("\\?shapeType=BACKGROUND", "_shapeType_BACKGROUND");
        processInfo.setSvgFile(svgFile);
        ProcessDefinition pd = this.getProcessServicesClient(kieServerId).getProcessDefinition(containerId, processId);
        if (!pd.getContainerId().equals(containerId)) {
            throw new ProcessDefinitionNotFoundException(kieServerId, containerId, processId);
        }
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> labels = new ArrayList<String>();
        if (pd.getNodes() != null) {
            Collection nodes = pd.getNodes();
            for (NodeDefinition node : nodes) {
                if (!node.getType().equals("HumanTaskNode")) continue;
                values.add(node.getUniqueId());
                labels.add(node.getName() + ":" + node.getUniqueId());
            }
        }
        processInfo.setValues(values);
        processInfo.setLabels(labels);
        processInfo.setContainerId(containerId);
        return processInfo;
    }

    private void loadConfig(Map<String, String> config) {
        EnteredCredentialsProvider credentialsProvider = new EnteredCredentialsProvider(config.get(USERNAME), config.get(PASSWORD));
        KieServerConfig kieConfig = new KieServerConfig();
        kieConfig.setHost(config.get(HOST)).setCredentialsProvider((CredentialsProvider)credentialsProvider);
        this.configs.put(kieConfig.getHost(), kieConfig);
        try {
            kieConfig.setClient(this.createKieServicesClient(kieConfig));
            logger.info("Loaded kie server configuration: {}", (Object)kieConfig);
        }
        catch (Exception e) {
            logger.info("Unable to create kie server configuration for {}. Retry asynchronously", (Object)kieConfig);
            this.retryConnection(kieConfig);
        }
        this.configs.put(kieConfig.getHost(), kieConfig);
        logger.info("Loaded kie server configuration: {}", (Object)kieConfig);
    }

    private KieServicesClient createKieServicesClient(KieServerConfig config) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)config.getHost(), (CredentialsProvider)config.getCredentialsProvider());
        configuration.setTimeout(60000L);
        configuration.setMarshallingFormat(MarshallingFormat.JSON);
        return KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration);
    }

    private KieServicesClient getClient(String kieServerId) throws InvalidKieServerException {
        return this.configs.values().stream().filter(config -> kieServerId.equals(config.getId())).findFirst().orElseThrow(() -> new InvalidKieServerException(kieServerId)).getClient();
    }

    private UIServicesClient getUIServicesClient(String kieServerId) throws InvalidKieServerException {
        return (UIServicesClient)this.getClient(kieServerId).getServicesClient(UIServicesClient.class);
    }

    private ProcessServicesClient getProcessServicesClient(String kieServerId) throws InvalidKieServerException {
        return (ProcessServicesClient)this.getClient(kieServerId).getServicesClient(ProcessServicesClient.class);
    }

    void retryConnection(KieServerConfig kieConfig) {
        this.executorService.schedule((Runnable)new KieServerClientConnector(this, kieConfig), 2L, TimeUnit.SECONDS);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ KieServicesClient access$100(KieServiceImpl x0, KieServerConfig x1) {
        return x0.createKieServicesClient(x1);
    }
}

