/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.kie.processmigration.model.Execution;
import org.kie.processmigration.model.MigrationDefinition;
import org.kie.processmigration.model.MigrationReport;

@Entity
@Table(name="migrations")
@SequenceGenerator(name="migrationIdSeq", sequenceName="MIGRATION_ID_SEQ")
@NamedQueries(value={@NamedQuery(name="Migration.findAll", query="SELECT m FROM Migration m"), @NamedQuery(name="Migration.findById", query="SELECT m FROM Migration m WHERE m.id = :id"), @NamedQuery(name="Migration.findByStatus", query="SELECT m FROM Migration m WHERE m.status IN :statuses")})
public class Migration
implements Serializable {
    private static final long serialVersionUID = 7212317252498596171L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="migrationIdSeq")
    private Long id;
    @Embedded
    private MigrationDefinition definition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Column(name="created_at")
    private Instant createdAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Column(name="finished_at")
    private Instant finishedAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Column(name="started_at")
    private Instant startedAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Column(name="cancelled_at")
    private Instant cancelledAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Column(name="error_message")
    @Lob
    private String errorMessage;
    private Execution.ExecutionStatus status;
    @JsonIgnore
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="migration_id")
    private List<MigrationReport> reports = new ArrayList();

    public Migration() {
    }

    public Migration(MigrationDefinition definition) {
        Instant now;
        this.definition = definition;
        this.createdAt = now = Instant.now();
        this.status = Execution.ExecutionType.ASYNC.equals((Object)definition.getExecution().getType()) && definition.getExecution().getScheduledStartTime() != null && now.isBefore(definition.getExecution().getScheduledStartTime()) ? Execution.ExecutionStatus.SCHEDULED : Execution.ExecutionStatus.CREATED;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MigrationDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(MigrationDefinition definition) {
        this.definition = definition;
    }

    public Execution.ExecutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(Execution.ExecutionStatus status) {
        this.status = status;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public Instant getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(Instant startedAt) {
        this.startedAt = startedAt;
    }

    public Instant getFinishedAt() {
        return this.finishedAt;
    }

    public void setFinishedAt(Instant finishedAt) {
        this.finishedAt = finishedAt;
    }

    public Instant getCancelledAt() {
        return this.cancelledAt;
    }

    public void setCancelledAt(Instant cancelledAt) {
        this.cancelledAt = cancelledAt;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public List<MigrationReport> getReports() {
        return this.reports;
    }

    public void setReports(List<MigrationReport> reports) {
        this.reports = reports;
    }

    public Migration start() {
        this.startedAt = Instant.now();
        this.status = Execution.ExecutionStatus.STARTED;
        return this;
    }

    public Migration complete(Boolean hasErrors) {
        this.finishedAt = Instant.now();
        this.status = Boolean.TRUE.equals(hasErrors) ? Execution.ExecutionStatus.FAILED : Execution.ExecutionStatus.COMPLETED;
        return this;
    }

    public Migration cancel() {
        this.cancelledAt = Instant.now();
        this.status = Execution.ExecutionStatus.CANCELLED;
        return this;
    }

    public Migration fail(Exception e) {
        this.finishedAt = Instant.now();
        this.status = Execution.ExecutionStatus.FAILED;
        this.errorMessage = e.toString();
        return this;
    }
}

