/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.service.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.inject.Inject;
import org.kie.processmigration.model.Migration;
import org.kie.processmigration.model.exceptions.InvalidMigrationException;
import org.kie.processmigration.model.exceptions.MigrationNotFoundException;
import org.kie.processmigration.service.MigrationService;
import org.kie.processmigration.service.SchedulerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Startup
public class EjbTimerSchedulerServiceImpl
implements SchedulerService {
    private static final Logger logger = LoggerFactory.getLogger(EjbTimerSchedulerServiceImpl.class);
    @Resource
    private TimerService timerService;
    @Inject
    private MigrationService migrationService;

    @Timeout
    public void doMigration(Timer timer) {
        Long migrationId = (Long)timer.getInfo();
        try {
            this.migrationService.migrate(this.migrationService.get(migrationId));
        }
        catch (InvalidMigrationException | MigrationNotFoundException e) {
            logger.error("Unable to perform asynchronous migration", e);
        }
    }

    public void scheduleMigration(Migration migration) {
        Long migrationId = migration.getId();
        if (migration.getDefinition().getExecution().getScheduledStartTime() == null) {
            this.timerService.createTimer(new Date(), (Serializable)migrationId);
        } else {
            Date startTime = Date.from(migration.getDefinition().getExecution().getScheduledStartTime());
            this.timerService.createTimer(startTime, (Serializable)migrationId);
        }
    }

    public void reScheduleMigration(Migration migration) {
        Optional<Timer> timer = this.timerService.getTimers().stream().filter(t -> t.getInfo().equals(migration.getId())).findFirst();
        if (timer.isPresent()) {
            timer.get().cancel();
            this.scheduleMigration(migration);
        }
    }
}

