/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Map;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.kie.processmigration.model.ProcessRef;

@Entity
@Table(name="plans")
@SequenceGenerator(name="planIdSeq", sequenceName="PLAN_ID_SEQ")
@NamedQueries(value={@NamedQuery(name="Plan.findAll", query="SELECT p FROM Plan p"), @NamedQuery(name="Plan.findById", query="SELECT p FROM Plan p WHERE p.id = :id")})
public class Plan
implements Serializable {
    private static final long serialVersionUID = 1244535648642365858L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="planIdSeq")
    private long id;
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String description;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="containerId", column=@Column(name="source_container_id")), @AttributeOverride(name="processId", column=@Column(name="source_process_id"))})
    private ProcessRef source;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="containerId", column=@Column(name="target_container_id")), @AttributeOverride(name="processId", column=@Column(name="target_process_id"))})
    private ProcessRef target;
    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="source")
    @Column(name="target")
    @CollectionTable(name="plan_mappings", joinColumns={@JoinColumn(name="plan_id")})
    private Map<String, String> mappings;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProcessRef getSource() {
        return this.source;
    }

    public void setSource(ProcessRef source) {
        this.source = source;
    }

    public ProcessRef getTarget() {
        return this.target;
    }

    public void setTarget(ProcessRef target) {
        this.target = target;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public Plan copy(Plan plan) {
        this.name = plan.getName();
        this.description = plan.getDescription();
        this.source = plan.getSource();
        this.target = plan.getTarget();
        this.mappings = plan.getMappings();
        return this;
    }
}

