/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.service.impl;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import org.kie.processmigration.model.Plan;
import org.kie.processmigration.model.exceptions.PlanNotFoundException;
import org.kie.processmigration.service.PlanService;

@ApplicationScoped
public class PlanServiceImpl
implements PlanService {
    @PersistenceContext
    private EntityManager em;

    public List<Plan> findAll() {
        return this.em.createNamedQuery("Plan.findAll", Plan.class).getResultList();
    }

    public Plan get(Long id) throws PlanNotFoundException {
        TypedQuery query = this.em.createNamedQuery("Plan.findById", Plan.class);
        query.setParameter("id", (Object)id);
        try {
            return (Plan)query.getSingleResult();
        }
        catch (NoResultException e) {
            throw new PlanNotFoundException(id);
        }
    }

    @Transactional
    public Plan delete(Long id) throws PlanNotFoundException {
        Plan plan = this.get(id);
        this.em.remove((Object)plan);
        return plan;
    }

    @Transactional
    public Plan create(Plan plan) {
        this.em.persist((Object)plan);
        return plan;
    }

    @Transactional
    public Plan update(Long id, Plan plan) throws PlanNotFoundException {
        return this.create(this.get(id).copy(plan));
    }
}

