/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.droolsassert.util.PerfStat;
import org.droolsassert.util.Stat;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.DefaultAgendaEventListener;

public class RulesChronoAgendaEventListener
extends DefaultAgendaEventListener {
    protected final ConcurrentHashMap<String, PerfStat> rulesStat = new ConcurrentHashMap();
    protected final long aggregationTimeMs;
    protected final String sessionPreffix;

    public RulesChronoAgendaEventListener() {
        this(null, PerfStat.AGGREGATION_TIME_MS);
    }

    public RulesChronoAgendaEventListener(long aggregationTimeMs) {
        this(null, aggregationTimeMs);
    }

    public RulesChronoAgendaEventListener(String sessionPreffix) {
        this(sessionPreffix, PerfStat.AGGREGATION_TIME_MS);
    }

    public RulesChronoAgendaEventListener(String sessionPreffix, long aggregationTimeMs) {
        this.sessionPreffix = sessionPreffix;
        this.aggregationTimeMs = aggregationTimeMs;
    }

    public TreeMap<String, Stat> getPerfStat() {
        TreeMap<String, Stat> result = new TreeMap<String, Stat>();
        for (Map.Entry<String, PerfStat> e : this.rulesStat.entrySet()) {
            result.put(e.getKey(), e.getValue().getStat());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeMatchFired(BeforeMatchFiredEvent event) {
        String ruleName = event.getMatch().getRule().getName();
        PerfStat ruleStat = this.rulesStat.get(ruleName);
        if (ruleStat == null) {
            ConcurrentHashMap<String, PerfStat> concurrentHashMap = this.rulesStat;
            synchronized (concurrentHashMap) {
                if (ruleStat == null) {
                    ruleStat = new PerfStat(this.sessionPreffix == null ? ruleName : this.sessionPreffix + ruleName, this.aggregationTimeMs);
                    this.rulesStat.put(ruleName, ruleStat);
                }
            }
        }
        ruleStat.start();
    }

    public void afterMatchFired(AfterMatchFiredEvent event) {
        this.rulesStat.get(event.getMatch().getRule().getName()).stop();
    }

    public void reset() {
        this.rulesStat.values().forEach(PerfStat::reset);
    }
}

