/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert.util;

import java.util.concurrent.atomic.AtomicLong;
import org.droolsassert.util.PerfStat;
import org.droolsassert.util.Stat;

public final class StatImpl
implements Stat {
    private static final long serialVersionUID = -9173318780008157727L;
    private String domain;
    volatile long leapsCount;
    volatile long leapsCountSample;
    volatile long failedLeapsCount;
    volatile double totalTimeNs;
    volatile double totalTimeSampleNs;
    volatile double avgTimeSampleMs;
    volatile double leapTimeMs;
    volatile double minTimeMs;
    volatile double minTimeSampleMs;
    volatile double minTimeThresholdMs;
    volatile double maxTimeMs;
    volatile double maxTimeSampleMs;
    volatile double maxTimeThresholdMs;
    final AtomicLong peersCount = new AtomicLong();

    public StatImpl() {
    }

    public StatImpl(String domain) {
        this.domain = domain;
    }

    @Override
    public synchronized void reset() {
        this.totalTimeNs = 0.0;
        this.totalTimeSampleNs = 0.0;
        this.maxTimeMs = 0.0;
        this.maxTimeSampleMs = 0.0;
        this.maxTimeThresholdMs = 0.0;
        this.minTimeMs = 0.0;
        this.minTimeSampleMs = 0.0;
        this.minTimeThresholdMs = 0.0;
        this.leapsCount = 0L;
        this.leapsCountSample = 0L;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public long getLeapsCount() {
        return this.leapsCount;
    }

    @Override
    public double getLeapTimeMs() {
        return this.leapTimeMs;
    }

    @Override
    public double getMinTimeMs() {
        return this.minTimeMs;
    }

    @Override
    public double getMinTimeSampleMs() {
        return this.minTimeSampleMs;
    }

    @Override
    public double getMaxTimeMs() {
        return this.maxTimeMs;
    }

    @Override
    public double getMaxTimeSampleMs() {
        return this.maxTimeSampleMs;
    }

    @Override
    public double getAvgTimeMs() {
        return PerfStat.round(this.totalTimeNs / (double)this.leapsCount);
    }

    @Override
    public double getAvgTimeSampleMs() {
        return this.avgTimeSampleMs;
    }

    @Override
    public double getTotalTimeMs() {
        return PerfStat.round(this.totalTimeNs);
    }

    @Override
    public long getFailedLeapsCount() {
        return this.failedLeapsCount;
    }

    @Override
    public long getPeersCount() {
        return this.peersCount.get();
    }

    public String toString() {
        return String.format("%,.2f %,.2f %,.2f", this.minTimeMs, this.getAvgTimeMs(), this.maxTimeMs);
    }
}

