/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.droolsassert.RulesChronoAgendaEventListener;
import org.droolsassert.util.PerfStat;
import org.droolsassert.util.Stat;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;

public class RulesChronoChartRecorder
extends RulesChronoAgendaEventListener {
    public static final int RETENTION_PERIOD_MIN = Integer.parseInt(System.getProperty("org.droolsassert.RulesChronoChartRecorderRetentionPeriodMin", "180"));
    protected final ConcurrentHashMap<String, TimeSeries> rulesMaxChart = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, TimeSeries> rulesAvgChart = new ConcurrentHashMap();
    protected final Timer timer = new Timer(((Object)((Object)this)).getClass().getSimpleName(), true);
    protected long retentionPeriodSec = TimeUnit.MINUTES.toSeconds(RETENTION_PERIOD_MIN);

    public RulesChronoChartRecorder() {
        this(null, RETENTION_PERIOD_MIN);
    }

    public RulesChronoChartRecorder(long aggregationPeriodMs) {
        this(null, aggregationPeriodMs);
    }

    public RulesChronoChartRecorder(String sessionPreffix) {
        this(sessionPreffix, RETENTION_PERIOD_MIN);
    }

    public RulesChronoChartRecorder(String sessionPreffix, long aggregationPeriodMs) {
        super(sessionPreffix, aggregationPeriodMs);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                RulesChronoChartRecorder.this.recordTimeSeries();
            }
        }, 0L, aggregationPeriodMs);
    }

    public void recordTimeSeries() {
        for (Map.Entry entry : this.rulesStat.entrySet()) {
            String rule = (String)entry.getKey();
            Stat stat = ((PerfStat)entry.getValue()).getStat();
            if (!this.rulesMaxChart.containsKey(rule)) {
                this.initTimeSeries(rule, stat);
            }
            Second period = new Second();
            this.rulesMaxChart.get(rule).addOrUpdate((RegularTimePeriod)period, stat.getMaxTimeSampleMs());
            this.rulesAvgChart.get(rule).addOrUpdate((RegularTimePeriod)period, stat.getAvgTimeSampleMs());
        }
    }

    public void initTimeSeries(String rule, Stat stat) {
        TimeSeries series = new TimeSeries((Comparable)((Object)stat.getDomain()));
        series.setMaximumItemAge(this.retentionPeriodSec);
        this.rulesMaxChart.put(rule, series);
        series = new TimeSeries((Comparable)((Object)stat.getDomain()));
        series.setMaximumItemAge(this.retentionPeriodSec);
        this.rulesAvgChart.put(rule, series);
    }

    public void setRetentionPeriod(long time, TimeUnit units) {
        this.retentionPeriodSec = units.toSeconds(time);
    }

    public TreeMap<String, TimeSeries> getRulesMaxChart() {
        return new TreeMap<String, TimeSeries>(this.rulesMaxChart);
    }

    public TreeMap<String, TimeSeries> getRulesAvgChart() {
        return new TreeMap<String, TimeSeries>(this.rulesAvgChart);
    }
}

