/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert.util;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.apache.commons.lang3.time.StopWatch;
import org.droolsassert.util.JmxUtils;
import org.droolsassert.util.Stat;
import org.droolsassert.util.StatImpl;

public class PerfStat {
    public static final String DOMAIN = System.getProperty("perfstat.domain", "org.droolsassert.perf");
    public static final long AGGREGATION_PERIOD_MS = Long.parseLong(System.getProperty("perfstat.aggregationPeriodMs", "4000"));
    private static final ConcurrentHashMap<String, StatImpl> stats = new ConcurrentHashMap();
    private ThreadLocal<StopWatch> stopWatch = ThreadLocal.withInitial(() -> new StopWatch());
    private StatImpl stat;
    private long lastAggregationTimeMs = System.currentTimeMillis();
    private long aggregationPeriodMs;

    public static Stat getPerfStat(String domain) {
        return stats.get(domain);
    }

    public static TreeMap<String, StatImpl> getPerfStat() {
        return new TreeMap<String, StatImpl>(stats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(Map<String, StatImpl> rhsStats) {
        ConcurrentHashMap<String, StatImpl> concurrentHashMap = stats;
        synchronized (concurrentHashMap) {
            for (Map.Entry<String, StatImpl> rhsStat : rhsStats.entrySet()) {
                StatImpl lhs = stats.get(rhsStat.getKey());
                StatImpl rhs = rhsStat.getValue();
                if (lhs == null) {
                    stats.put(rhsStat.getKey(), rhs);
                    continue;
                }
                lhs.leapsCount += rhs.leapsCount;
                lhs.totalTimeNs += rhs.totalTimeNs;
                if (rhs.minTimeMs < lhs.minTimeMs) {
                    lhs.minTimeMs = rhs.minTimeMs;
                }
                if (!(rhs.maxTimeMs > lhs.maxTimeMs)) continue;
                lhs.maxTimeMs = rhs.maxTimeMs;
            }
        }
    }

    public static void resetAll() {
        stats.values().forEach(StatImpl::reset);
    }

    public PerfStat(String domain) {
        this(domain, AGGREGATION_PERIOD_MS);
    }

    public PerfStat(String domain, long aggregationPeriodMs) {
        this.aggregationPeriodMs = aggregationPeriodMs;
        this.stat = stats.get(domain);
        if (this.stat == null) {
            this.initStat(domain);
        }
        this.stat.peersCount.incrementAndGet();
    }

    protected void finalize() throws Throwable {
        this.stat.peersCount.decrementAndGet();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStat(String domain) {
        ConcurrentHashMap<String, StatImpl> concurrentHashMap = stats;
        synchronized (concurrentHashMap) {
            this.stat = stats.get(domain);
            if (this.stat == null) {
                this.stat = new StatImpl(domain);
                stats.put(domain, this.stat);
                JmxUtils.registerMBean(String.format("%s:type=%s", DOMAIN, ObjectName.quote(domain)), this.stat, Stat.class);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerfStat start() {
        if (this.stopWatch.get().isStarted()) {
            StatImpl statImpl = this.stat;
            synchronized (statImpl) {
                ++this.stat.failedLeapsCount;
            }
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (this.stat.leapsCountSample > 0L && currentTimeMillis > this.lastAggregationTimeMs + this.aggregationPeriodMs) {
            StatImpl statImpl = this.stat;
            synchronized (statImpl) {
                if (this.stat.leapsCountSample > 0L && currentTimeMillis > this.lastAggregationTimeMs + this.aggregationPeriodMs) {
                    this.lastAggregationTimeMs = currentTimeMillis;
                    this.stat.avgTimeSampleMs = PerfStat.round(this.stat.totalTimeSampleNs / (double)this.stat.leapsCountSample);
                    this.stat.leapsCountSample = 0L;
                    this.stat.totalTimeSampleNs = 0.0;
                    this.stat.maxTimeSampleMs = this.stat.maxTimeThresholdMs;
                    this.stat.maxTimeThresholdMs = 0.0;
                    this.stat.minTimeSampleMs = this.stat.minTimeThresholdMs;
                    this.stat.minTimeThresholdMs = 0.0;
                }
            }
        }
        this.stopWatch.get().reset();
        this.stopWatch.get().start();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long stop() {
        this.stopWatch.get().stop();
        long timeNs = this.stopWatch.get().getNanoTime();
        double timeMs = PerfStat.round(timeNs);
        StatImpl statImpl = this.stat;
        synchronized (statImpl) {
            this.stat.leapTimeMs = timeMs;
            this.stat.totalTimeNs += (double)timeNs;
            this.stat.totalTimeSampleNs += (double)timeNs;
            if (timeMs > this.stat.maxTimeMs) {
                this.stat.maxTimeMs = timeMs;
            }
            if (timeMs > this.stat.maxTimeThresholdMs) {
                this.stat.maxTimeThresholdMs = timeMs;
            }
            if (timeMs < this.stat.minTimeMs || this.stat.minTimeMs == 0.0) {
                this.stat.minTimeMs = timeMs;
            }
            if (timeMs < this.stat.minTimeThresholdMs || this.stat.minTimeThresholdMs == 0.0) {
                this.stat.minTimeThresholdMs = timeMs;
            }
            ++this.stat.leapsCount;
            ++this.stat.leapsCountSample;
        }
        return timeNs;
    }

    public void reset() {
        this.stat.reset();
    }

    public StopWatch getStopWatch() {
        return this.stopWatch.get();
    }

    public Stat getStat() {
        return this.stat;
    }

    static double round(double nanos) {
        double scale = 1000.0;
        double nsInMs = 1000000.0;
        return (double)Math.round(nanos * scale / nsInMs) / scale;
    }

    public String toString() {
        return this.stat.toString();
    }
}

