/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.IOException;

public final class JsonUtils {
    private static final ObjectMapper DEFAULT_MAPPER = JsonUtils.newFieldMapper(new JsonFactory(), JsonInclude.Include.NON_NULL);
    private static final ObjectMapper YAML_MAPPER = JsonUtils.newFieldMapper((JsonFactory)new YAMLFactory(), JsonInclude.Include.NON_NULL);

    private JsonUtils() {
    }

    public static String toJson(Object obj) {
        return JsonUtils.toJson(obj, false);
    }

    public static String toJson(Object obj, boolean prettyPrint) {
        try {
            return prettyPrint ? DEFAULT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(obj) : DEFAULT_MAPPER.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot convert to JSON.", e);
        }
    }

    public static String toYaml(Object obj) {
        try {
            return YAML_MAPPER.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot convert to YAML.", e);
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)DEFAULT_MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Cannot read %s from JSON:%n%s", clazz.getSimpleName(), json), e);
        }
    }

    public static <T> T fromYaml(String yaml, Class<T> clazz) {
        try {
            return (T)YAML_MAPPER.readValue(yaml, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Cannot read %s from YAML:%n%s", clazz.getSimpleName(), yaml), e);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return DEFAULT_MAPPER;
    }

    private static ObjectMapper newFieldMapper(JsonFactory factory, JsonInclude.Include inclusion) {
        ObjectMapper mapper = new ObjectMapper(factory);
        mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        mapper.setSerializationInclusion(inclusion);
        return mapper;
    }

    static {
        DEFAULT_MAPPER.registerModule((Module)new JodaModule());
        DEFAULT_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        DEFAULT_MAPPER.activateDefaultTyping(DEFAULT_MAPPER.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.OBJECT_AND_NON_CONCRETE);
        YAML_MAPPER.registerModule((Module)new JodaModule());
        YAML_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }
}

