/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;

public class ReentrantFileLock
extends ReentrantLock {
    private static final long serialVersionUID = 6495726261995738151L;
    private static final long RETRY_NS = 50L;
    private static final Map<Integer, AtomicInteger> fileLockHoldCount = new ConcurrentHashMap<Integer, AtomicInteger>();
    private final FileChannel lockFileChannel;
    private final int id;
    private volatile FileLock fileLock;

    public static final ReentrantFileLockFactory newReentrantFileLockFactory(String filePath) {
        return new ReentrantFileLockFactory(new File(filePath));
    }

    public static final ReentrantFileLockFactory newReentrantFileLockFactory(File file) {
        return new ReentrantFileLockFactory(file);
    }

    public ReentrantFileLock(int id, FileChannel lockFileChannel) {
        this.id = id;
        this.lockFileChannel = lockFileChannel;
    }

    @Override
    public void lock() {
        super.lock();
        if (this.incrementAndGetFileLockHoldCount() == 1) {
            try {
                this.fileLock = this.lockFileChannel.lock(this.id, 1L, false);
            }
            catch (Exception e) {
                this.decrementAndGetFileLockHoldCount();
                super.unlock();
                throw new RuntimeException("Cannot acquire file lock", e);
            }
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        block4: {
            super.lockInterruptibly();
            if (this.incrementAndGetFileLockHoldCount() == 1) {
                do {
                    try {
                        this.fileLock = this.lockFileChannel.tryLock(this.id, 1L, false);
                    }
                    catch (IOException e) {
                        this.decrementAndGetFileLockHoldCount();
                        super.unlock();
                        throw new RuntimeException("Cannot acquire file lock", e);
                    }
                    if (this.fileLock != null) break block4;
                    LockSupport.parkNanos(50L);
                } while (!Thread.currentThread().isInterrupted());
                this.decrementAndGetFileLockHoldCount();
                super.unlock();
                throw new InterruptedException();
            }
        }
    }

    @Override
    public boolean tryLock() {
        boolean locked = super.tryLock();
        if (locked && this.incrementAndGetFileLockHoldCount() == 1) {
            try {
                this.fileLock = this.lockFileChannel.tryLock(this.id, 1L, false);
            }
            catch (IOException e) {
                this.decrementAndGetFileLockHoldCount();
                super.unlock();
                throw new RuntimeException("Cannot acquire file lock", e);
            }
            if (this.fileLock == null) {
                this.decrementAndGetFileLockHoldCount();
                super.unlock();
                locked = false;
            }
        }
        return locked;
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        boolean locked;
        block3: {
            long deadline = System.nanoTime() + unit.toNanos(timeout);
            locked = super.tryLock(timeout, unit);
            if (!locked || this.incrementAndGetFileLockHoldCount() != 1) break block3;
            do {
                try {
                    this.fileLock = this.lockFileChannel.tryLock(this.id, 1L, false);
                }
                catch (IOException e) {
                    this.decrementAndGetFileLockHoldCount();
                    super.unlock();
                    throw new RuntimeException("Cannot acquire file lock", e);
                }
                if (this.fileLock != null) break block3;
                LockSupport.parkNanos(50L);
            } while (!Thread.currentThread().isInterrupted() && System.nanoTime() <= deadline);
            super.unlock();
            locked = false;
        }
        return locked;
    }

    @Override
    public void unlock() {
        if (this.decrementAndGetFileLockHoldCount() == 0) {
            try {
                this.fileLock.release();
                this.fileLock = null;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot release file lock", e);
            }
            finally {
                super.unlock();
            }
        } else {
            super.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int incrementAndGetFileLockHoldCount() {
        AtomicInteger lockCount = fileLockHoldCount.get(this.id);
        if (lockCount == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                lockCount = fileLockHoldCount.get(this.id);
                if (lockCount == null) {
                    lockCount = new AtomicInteger();
                    fileLockHoldCount.put(this.id, lockCount);
                }
            }
        }
        return lockCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decrementAndGetFileLockHoldCount() {
        int decremented = fileLockHoldCount.get(this.id).decrementAndGet();
        if (decremented == 0) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (fileLockHoldCount.get(this.id).get() == 0) {
                    fileLockHoldCount.remove(this.id);
                }
            }
        }
        return decremented;
    }

    public static class ReentrantFileLockFactory {
        private final FileChannel lockFileChannel;

        private ReentrantFileLockFactory(File file) {
            try {
                File absoluteFile = file.getAbsoluteFile();
                FileUtils.forceMkdirParent((File)absoluteFile);
                this.lockFileChannel = new FileOutputStream(absoluteFile).getChannel();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot initialize file lock factory", e);
            }
        }

        public ReentrantFileLock newLock(String name) {
            return this.newLock(name.hashCode());
        }

        public ReentrantFileLock newLock(int id) {
            return new ReentrantFileLock(id, this.lockFileChannel);
        }
    }
}

