/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.droolsassert.RulesChronoAgendaEventListener;
import org.droolsassert.util.AlphanumComparator;
import org.droolsassert.util.PerfStat;
import org.droolsassert.util.Stat;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;

public class RulesChronoChartRecorder
extends RulesChronoAgendaEventListener {
    public static final int RETENTION_PERIOD_MIN = Integer.parseInt(System.getProperty("org.droolsassert.RulesChronoChartRecorder.retentionPeriodMin", "180"));
    private static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(0, new ThreadFactoryBuilder().setNameFormat("RulesChronoChartRecorder%s").setDaemon(true).build());
    protected final ConcurrentHashMap<String, TimeSeries> rulesMaxChart = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, TimeSeries> rulesAvgChart = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, TimeSeries> rulesMinChart = new ConcurrentHashMap();
    protected TimeSeries globalMaxChart = new TimeSeries((Comparable)((Object)"globalMax"));
    protected TimeSeries globalAvgChart = new TimeSeries((Comparable)((Object)"globalAvg"));
    protected TimeSeries globalMinChart = new TimeSeries((Comparable)((Object)"globalMin"));
    protected long retentionPeriodSec = TimeUnit.MINUTES.toSeconds(RETENTION_PERIOD_MIN);
    private EnumSet<DataType> dataTypes = EnumSet.allOf(DataType.class);
    private EnumSet<ThresholdType> thresholdTypes = EnumSet.noneOf(ThresholdType.class);
    private volatile boolean recordingStarted;

    public RulesChronoChartRecorder() {
        this(PerfStat.getDefaultAggregationPeriodMs());
    }

    public RulesChronoChartRecorder(long aggregationPeriodMs) {
        super(aggregationPeriodMs);
        this.scheduleRecording(aggregationPeriodMs);
    }

    public RulesChronoChartRecorder withRetentionPeriod(long time, TimeUnit units) {
        this.retentionPeriodSec = units.toSeconds(time);
        this.globalMaxChart.setMaximumItemAge(this.retentionPeriodSec);
        this.globalAvgChart.setMaximumItemAge(this.retentionPeriodSec);
        this.globalMinChart.setMaximumItemAge(this.retentionPeriodSec);
        return this;
    }

    public RulesChronoChartRecorder withDataTypes(DataType ... dataTypes) {
        this.dataTypes = EnumSet.copyOf(Arrays.asList(dataTypes));
        return this;
    }

    public RulesChronoChartRecorder withMaxThreshold(double threshold) {
        ThresholdType.Max.threshold = threshold;
        this.thresholdTypes.add(ThresholdType.Max);
        return this;
    }

    public RulesChronoChartRecorder withAvgThreshold(double threshold) {
        ThresholdType.Avg.threshold = threshold;
        this.thresholdTypes.add(ThresholdType.Avg);
        return this;
    }

    public RulesChronoChartRecorder withMinThreshold(double threshold) {
        ThresholdType.Min.threshold = threshold;
        this.thresholdTypes.add(ThresholdType.Min);
        return this;
    }

    @Override
    public RulesChronoChartRecorder withPackageName(boolean usePackageName) {
        super.withPackageName(usePackageName);
        return this;
    }

    @Override
    public RulesChronoChartRecorder withSessionPrefix(String sessionPrefix) {
        super.withSessionPrefix(sessionPrefix);
        return this;
    }

    protected void recordTimeSeries() {
        Second period = new Second();
        double globalMax = 0.0;
        double globalTotal = 0.0;
        double globalMin = Double.MAX_VALUE;
        Set es = this.rulesStat.entrySet();
        for (Map.Entry entry : es) {
            String rule = (String)entry.getKey();
            Stat stat = ((PerfStat)entry.getValue()).getStat();
            if (!this.rulesMaxChart.containsKey(rule)) {
                if (!(this.thresholdTypes.isEmpty() || this.thresholdTypes.contains((Object)ThresholdType.Max) && ThresholdType.Max.check(stat.getMaxTimeSampleMs()) || this.thresholdTypes.contains((Object)ThresholdType.Avg) && ThresholdType.Avg.check(stat.getAvgTimeSampleMs()) || this.thresholdTypes.contains((Object)ThresholdType.Min) && ThresholdType.Min.check(stat.getMinTimeSampleMs()))) continue;
                this.initTimeSeries(rule, stat);
                this.recordingStarted = true;
            }
            if (this.dataTypes.contains((Object)DataType.RulesMax)) {
                this.rulesMaxChart.get(rule).addOrUpdate((RegularTimePeriod)period, stat.getMaxTimeSampleMs());
            }
            if (this.dataTypes.contains((Object)DataType.RulesAvg)) {
                this.rulesAvgChart.get(rule).addOrUpdate((RegularTimePeriod)period, stat.getAvgTimeSampleMs());
            }
            if (this.dataTypes.contains((Object)DataType.RulesMin)) {
                this.rulesMinChart.get(rule).addOrUpdate((RegularTimePeriod)period, stat.getMinTimeSampleMs());
            }
            if (this.dataTypes.contains((Object)DataType.GlobalMax) && globalMax < stat.getMaxTimeSampleMs()) {
                globalMax = stat.getMaxTimeSampleMs();
            }
            if (this.dataTypes.contains((Object)DataType.GlobalAvg)) {
                globalTotal += stat.getAvgTimeSampleMs();
            }
            if (!this.dataTypes.contains((Object)DataType.GlobalMin) || !(globalMin > stat.getMinTimeSampleMs())) continue;
            globalMin = stat.getMinTimeSampleMs();
        }
        if (!this.recordingStarted) {
            return;
        }
        if (this.dataTypes.contains((Object)DataType.GlobalMax)) {
            this.globalMaxChart.addOrUpdate((RegularTimePeriod)period, globalMax);
        }
        if (this.dataTypes.contains((Object)DataType.GlobalAvg)) {
            this.globalAvgChart.addOrUpdate((RegularTimePeriod)period, globalTotal / (double)es.size());
        }
        if (this.dataTypes.contains((Object)DataType.GlobalMin)) {
            this.globalMinChart.addOrUpdate((RegularTimePeriod)period, globalMin);
        }
    }

    private void initTimeSeries(String rule, Stat stat) {
        TimeSeries series = new TimeSeries((Comparable)((Object)stat.getFullName()));
        series.setMaximumItemAge(this.retentionPeriodSec);
        this.rulesMaxChart.put(rule, series);
        series = new TimeSeries((Comparable)((Object)stat.getFullName()));
        series.setMaximumItemAge(this.retentionPeriodSec);
        this.rulesAvgChart.put(rule, series);
        series = new TimeSeries((Comparable)((Object)stat.getFullName()));
        series.setMaximumItemAge(this.retentionPeriodSec);
        this.rulesMinChart.put(rule, series);
    }

    public TreeMap<String, TimeSeries> getRulesMaxChart() {
        TreeMap<String, TimeSeries> sorted = new TreeMap<String, TimeSeries>(AlphanumComparator.ALPHANUM_COMPARATOR);
        sorted.putAll(this.rulesMaxChart);
        return sorted;
    }

    public TreeMap<String, TimeSeries> getRulesAvgChart() {
        TreeMap<String, TimeSeries> sorted = new TreeMap<String, TimeSeries>(AlphanumComparator.ALPHANUM_COMPARATOR);
        sorted.putAll(this.rulesAvgChart);
        return sorted;
    }

    public TreeMap<String, TimeSeries> getRulesMinChart() {
        TreeMap<String, TimeSeries> sorted = new TreeMap<String, TimeSeries>(AlphanumComparator.ALPHANUM_COMPARATOR);
        sorted.putAll(this.rulesMinChart);
        return sorted;
    }

    public TimeSeries getGlobalMaxChart() {
        return this.globalMaxChart;
    }

    public TimeSeries getGlobalAvgChart() {
        return this.globalAvgChart;
    }

    public TimeSeries getGlobalMinChart() {
        return this.globalMinChart;
    }

    public boolean isRecordingStarted() {
        return this.recordingStarted;
    }

    @Override
    public void reset() {
        this.rulesMaxChart.clear();
        this.rulesAvgChart.clear();
        this.rulesMinChart.clear();
        this.globalMaxChart = new TimeSeries((Comparable)((Object)"globalMax"));
        this.globalMaxChart.setMaximumItemAge(this.retentionPeriodSec);
        this.globalAvgChart = new TimeSeries((Comparable)((Object)"globalAvg"));
        this.globalAvgChart.setMaximumItemAge(this.retentionPeriodSec);
        this.globalMinChart = new TimeSeries((Comparable)((Object)"globalMin"));
        this.globalMinChart.setMaximumItemAge(this.retentionPeriodSec);
        this.recordingStarted = false;
        super.reset();
    }

    private void scheduleRecording(long aggregationPeriodMs) {
        SelfDiscardWrapper wrapper = new SelfDiscardWrapper(this);
        ScheduledFuture<?> scheduled = EXECUTOR.scheduleAtFixedRate(wrapper, 0L, aggregationPeriodMs, TimeUnit.MILLISECONDS);
        wrapper.setScheduled(scheduled);
    }

    private static class SelfDiscardWrapper
    implements Runnable {
        private final WeakReference<RulesChronoChartRecorder> ref;
        private volatile ScheduledFuture<?> scheduled;

        private SelfDiscardWrapper(RulesChronoChartRecorder referent) {
            this.ref = new WeakReference<RulesChronoChartRecorder>(referent);
        }

        @Override
        public void run() {
            RulesChronoChartRecorder referent = (RulesChronoChartRecorder)((Object)this.ref.get());
            if (referent == null) {
                this.scheduled.cancel(false);
            } else {
                referent.recordTimeSeries();
            }
        }

        private void setScheduled(ScheduledFuture<?> scheduled) {
            this.scheduled = scheduled;
        }
    }

    static enum ThresholdType {
        Max,
        Avg,
        Min;

        private volatile double threshold;
        private double localThreshold;

        private boolean check(double value) {
            if (this.localThreshold == 0.0) {
                this.localThreshold = this.threshold;
            }
            return value > this.localThreshold;
        }
    }

    public static enum DataType {
        RulesMax,
        RulesAvg,
        RulesMin,
        GlobalMax,
        GlobalAvg,
        GlobalMin;

    }
}

