/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public final class ChartUtils {
    private ChartUtils() {
    }

    public static void pngChart(String fileName, int with, int height, Object ... seriesAndColors) {
        try {
            org.jfree.chart.ChartUtils.saveChartAsPNG((File)ChartUtils.file(fileName), (JFreeChart)ChartUtils.chart(ChartFactory.createTimeSeriesChart(null, null, null, null, (boolean)false, (boolean)false, (boolean)false), seriesAndColors), (int)with, (int)height);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create png chart", e);
        }
    }

    public static void pngChart(String fileName, List<TimeSeries> series, int with, int height) {
        try {
            org.jfree.chart.ChartUtils.saveChartAsPNG((File)ChartUtils.file(fileName), (JFreeChart)ChartUtils.chart(series, ChartFactory.createTimeSeriesChart(null, null, null, null, (boolean)true, (boolean)false, (boolean)false)), (int)with, (int)height);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create png chart", e);
        }
    }

    private static File file(String fileName) throws IOException {
        File file = new File(fileName).getAbsoluteFile();
        FileUtils.forceMkdir((File)file.getParentFile());
        return file;
    }

    public static JFreeChart chart(JFreeChart chart, Object ... seriesAndColors) {
        XYPlot plot = chart.getXYPlot();
        for (int i = 0; i < seriesAndColors.length; i += 2) {
            plot.setDataset(i / 2, (XYDataset)new TimeSeriesCollection((TimeSeries)seriesAndColors[i]));
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
            renderer.setSeriesPaint(0, (Paint)((Color)seriesAndColors[i + 1]));
            plot.setRenderer(i / 2, (XYItemRenderer)renderer);
        }
        ChartUtils.decoratePlot(plot);
        return chart;
    }

    public static JFreeChart chart(List<TimeSeries> series, JFreeChart chart) {
        XYPlot plot = chart.getXYPlot();
        int hue = 240;
        Color color = null;
        Comparable key = null;
        for (int i = 0; i < series.size(); ++i) {
            plot.setDataset(i, (XYDataset)new TimeSeriesCollection(series.get(i)));
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
            if (!series.get(i).getKey().equals(key)) {
                key = series.get(i).getKey();
                color = Color.getHSBColor((float)(hue + 81 * i) % 360.0f / 360.0f, 1.0f, 0.5f);
            } else {
                renderer.setDefaultSeriesVisibleInLegend(false);
            }
            renderer.setSeriesPaint(0, color);
            renderer.setLegendTextPaint(0, color);
            renderer.setLegendTextFont(0, new Font("Verdana", 1, 11));
            renderer.setLegendLine((Shape)new Rectangle(0, 0, 0, 0));
            plot.setRenderer(i, (XYItemRenderer)renderer);
        }
        chart.getLegend().setBorder(0.0, 0.0, 0.0, 0.0);
        ChartUtils.decoratePlot(plot);
        return chart;
    }

    private static void decoratePlot(XYPlot plot) {
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.gray);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.gray);
    }
}

