/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert.util;

import com.google.common.collect.MapMaker;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ReentrantFileLock
extends ReentrantLock {
    private static final long serialVersionUID = 6495726261995738151L;
    private static final long LOCK_RETRY_MS = 10L;
    private static final String cantAcquireFileLock = "Cannot acquire file lock";
    private static final ConcurrentMap<Integer, FileLockHolder> fileLocks = new MapMaker().weakValues().makeMap();
    private final File absoluteFile;
    private final FileChannel lockFileChannel;
    private final int id;
    private final FileLockHolder shared;

    public static final ReentrantFileLockFactory newReentrantFileLockFactory(String filePath) {
        return ReentrantFileLock.newReentrantFileLockFactory(false, filePath);
    }

    public static final ReentrantFileLockFactory newReentrantFileLockFactory(boolean fair, String filePath) {
        return new ReentrantFileLockFactory(fair, new File(filePath));
    }

    public static final ReentrantFileLockFactory newReentrantFileLockFactory(File file) {
        return ReentrantFileLock.newReentrantFileLockFactory(false, file);
    }

    public static final ReentrantFileLockFactory newReentrantFileLockFactory(boolean fair, File file) {
        return new ReentrantFileLockFactory(fair, file);
    }

    public static final ReentrantFileLockFactory newReentrantResourceLockFactory(String resourcePath) {
        return ReentrantFileLock.newReentrantResourceLockFactory(false, resourcePath);
    }

    public static final ReentrantFileLockFactory newReentrantResourceLockFactory(boolean fair, String resourcePath) {
        try {
            return new ReentrantFileLockFactory(fair, new File(Resources.getResource((String)resourcePath).toURI()));
        }
        catch (RuntimeException | URISyntaxException e) {
            throw new RuntimeException("Cannot create a lock from the resource " + resourcePath, e);
        }
    }

    private ReentrantFileLock(int id, FileChannel lockFileChannel, File absoluteFile) {
        this(false, id, lockFileChannel, absoluteFile);
    }

    private ReentrantFileLock(boolean fair, int id, FileChannel lockFileChannel, File absoluteFile) {
        super(fair);
        this.id = id;
        this.lockFileChannel = lockFileChannel;
        this.absoluteFile = absoluteFile;
        FileLockHolder defaultValue = new FileLockHolder();
        this.shared = (FileLockHolder)ObjectUtils.defaultIfNull((Object)fileLocks.putIfAbsent(id, defaultValue), (Object)defaultValue);
    }

    @Override
    public void lock() {
        block6: {
            super.lock();
            this.shared.modificationLock.lock();
            if (this.shared.holdCount.get() == 0) {
                try {
                    try {
                        this.shared.fileLock = this.lockFileChannel.lock(this.id, 1L, false);
                        this.shared.holdCount.incrementAndGet();
                        break block6;
                    }
                    catch (Exception e) {
                        super.unlock();
                        throw new RuntimeException(cantAcquireFileLock, e);
                    }
                }
                finally {
                    this.shared.modificationLock.unlock();
                }
            }
            this.shared.holdCount.incrementAndGet();
            this.shared.modificationLock.unlock();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        block8: {
            super.lockInterruptibly();
            this.shared.modificationLock.lockInterruptibly();
            if (this.shared.holdCount.get() == 0) {
                try {
                    do {
                        block7: {
                            try {
                                this.shared.fileLock = this.lockFileChannel.tryLock(this.id, 1L, false);
                                if (this.shared.fileLock == null) break block7;
                                this.shared.holdCount.incrementAndGet();
                                break block8;
                            }
                            catch (Exception e) {
                                super.unlock();
                                throw new RuntimeException(cantAcquireFileLock, e);
                            }
                        }
                        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
                    } while (!Thread.currentThread().isInterrupted());
                    super.unlock();
                    throw new InterruptedException();
                }
                finally {
                    this.shared.modificationLock.unlock();
                }
            }
            this.shared.holdCount.incrementAndGet();
            this.shared.modificationLock.unlock();
        }
    }

    @Override
    public boolean tryLock() {
        boolean locked;
        block9: {
            locked = super.tryLock();
            if (!locked) {
                return false;
            }
            if (!this.shared.modificationLock.tryLock()) {
                super.unlock();
                return false;
            }
            if (this.shared.holdCount.get() == 0) {
                try {
                    this.shared.fileLock = this.lockFileChannel.tryLock(this.id, 1L, false);
                    if (this.shared.fileLock != null) {
                        this.shared.holdCount.incrementAndGet();
                        break block9;
                    }
                    super.unlock();
                    return false;
                }
                catch (Exception e) {
                    super.unlock();
                    throw new RuntimeException(cantAcquireFileLock, e);
                }
                finally {
                    this.shared.modificationLock.unlock();
                }
            }
            this.shared.holdCount.incrementAndGet();
            this.shared.modificationLock.unlock();
        }
        return locked;
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        boolean locked = super.tryLock(timeout, unit);
        if (!locked) {
            return false;
        }
        if (!this.shared.modificationLock.tryLock(deadline - System.nanoTime(), TimeUnit.NANOSECONDS)) {
            super.unlock();
            return false;
        }
        if (this.shared.holdCount.get() == 0) {
            try {
                do {
                    try {
                        this.shared.fileLock = this.lockFileChannel.tryLock(this.id, 1L, false);
                        if (this.shared.fileLock != null) {
                            this.shared.holdCount.incrementAndGet();
                        }
                    }
                    catch (Exception e) {
                        super.unlock();
                        throw new RuntimeException(cantAcquireFileLock, e);
                    }
                    LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
                    if (!Thread.currentThread().isInterrupted()) continue;
                    super.unlock();
                    throw new InterruptedException();
                } while (System.nanoTime() <= deadline);
                super.unlock();
                locked = false;
            }
            finally {
                this.shared.modificationLock.unlock();
            }
        } else {
            this.shared.holdCount.incrementAndGet();
            this.shared.modificationLock.unlock();
        }
        return locked;
    }

    @Override
    public void unlock() {
        block6: {
            this.shared.modificationLock.lock();
            if (this.shared.holdCount.get() == 1) {
                try {
                    try {
                        this.shared.fileLock.release();
                        this.shared.fileLock = null;
                        this.shared.holdCount.decrementAndGet();
                        break block6;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot release file lock", e);
                    }
                }
                finally {
                    this.shared.modificationLock.unlock();
                    super.unlock();
                }
            }
            this.shared.holdCount.decrementAndGet();
            this.shared.modificationLock.unlock();
            super.unlock();
        }
    }

    public File getAbsoluteFile() {
        return this.absoluteFile;
    }

    @Override
    public String toString() {
        return String.format("%s-%s (%s)", this.absoluteFile.getName(), this.id, this.shared.holdCount);
    }

    /* synthetic */ ReentrantFileLock(boolean bl, int n, FileChannel fileChannel, File file, ReentrantFileLock reentrantFileLock) {
        this(bl, n, fileChannel, file);
    }

    private class FileLockHolder {
        private final ReentrantLock modificationLock = new ReentrantLock(true);
        private final AtomicInteger holdCount = new AtomicInteger();
        private volatile FileLock fileLock;

        private FileLockHolder() {
        }
    }

    public static class ReentrantFileLockFactory {
        private final boolean fair;
        private final File absoluteFile;
        private final FileChannel lockFileChannel;

        private ReentrantFileLockFactory(boolean fair, File file) {
            try {
                this.fair = fair;
                this.absoluteFile = file.getAbsoluteFile();
                FileUtils.forceMkdirParent((File)this.absoluteFile);
                this.lockFileChannel = new FileOutputStream(this.absoluteFile, true).getChannel();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot initialize file lock factory", e);
            }
        }

        public ReentrantFileLock newLock(String name) {
            return this.newLock(name.hashCode());
        }

        public ReentrantFileLock newLock(int id) {
            return new ReentrantFileLock(this.fair, id, this.lockFileChannel, this.absoluteFile, null);
        }
    }
}

