/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverListener;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.net.Advertiser;
import org.droolsassert.util.ReentrantFileLock;
import org.droolsassert.util.SharedRollingFileManager;

@Plugin(name="SharedRollingFile", category="Core", elementType="appender", printObject=true)
public final class SharedRollingFileAppender
extends AbstractOutputStreamAppender<RollingFileManager>
implements RolloverListener {
    public static final String PLUGIN_NAME = "SharedRollingFile";
    private final String fileName;
    private final String filePattern;
    private Object advertisement;
    private final Advertiser advertiser;
    private final Runnable processQueueRunnable = this::processQueue;
    private final ThreadPoolExecutor executor;
    private final LinkedBlockingQueue<LogEvent> queue;
    private final ReentrantFileLock fileLock;

    private SharedRollingFileAppender(String name, Layout<? extends Serializable> layout, Filter filter, SharedRollingFileManager manager, String fileName, String filePattern, boolean ignoreExceptions, boolean immediateFlush, Advertiser advertiser, Property[] properties, ReentrantFileLock fileLock, ThreadPoolExecutor executor, LinkedBlockingQueue<LogEvent> queue) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, properties, (OutputStreamManager)manager);
        if (advertiser != null) {
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.put("contentType", layout.getContentType());
            configuration.put("name", name);
            this.advertisement = advertiser.advertise(configuration);
        }
        this.fileName = fileName;
        this.filePattern = filePattern;
        this.advertiser = advertiser;
        this.fileLock = fileLock;
        this.executor = executor;
        this.queue = queue;
        executor.allowCoreThreadTimeOut(true);
        manager.addRolloverListener(this);
    }

    protected void processQueue() {
        if (this.queue.isEmpty()) {
            return;
        }
        this.fileLock.lock();
        try {
            try {
                this.getSharedRollingFileManager().openOutputStream();
                try {
                    LogEvent logEvent = this.queue.poll();
                    while (logEvent != null) {
                        this.doAppend(logEvent);
                        logEvent = this.queue.poll();
                    }
                }
                finally {
                    this.getSharedRollingFileManager().closeOutputStream();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot write to " + this.fileName, e);
            }
        }
        finally {
            this.fileLock.unlock();
        }
    }

    private SharedRollingFileManager getSharedRollingFileManager() {
        return (SharedRollingFileManager)this.getManager();
    }

    public void rolloverTriggered(String fileName) {
        Preconditions.checkState((boolean)this.fileLock.tryLock());
    }

    public void rolloverComplete(String fileName) {
        try {
            this.getSharedRollingFileManager().awaitAsyncRollover();
        }
        finally {
            this.fileLock.unlock();
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return stopped;
    }

    public void append(LogEvent event) {
        try {
            LogEvent snapshot = event.toImmutable();
            this.queue.put(snapshot);
            if (this.executor.getQueue().isEmpty()) {
                this.executor.execute(this.processQueueRunnable);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void doAppend(LogEvent event) {
        ((RollingFileManager)this.getManager()).checkRollover(event);
        super.append(event);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public <T extends TriggeringPolicy> T getTriggeringPolicy() {
        return (T)((RollingFileManager)this.getManager()).getTriggeringPolicy();
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    /* synthetic */ SharedRollingFileAppender(String string, Layout layout, Filter filter, SharedRollingFileManager sharedRollingFileManager, String string2, String string3, boolean bl, boolean bl2, Advertiser advertiser, Property[] propertyArray, ReentrantFileLock reentrantFileLock, ThreadPoolExecutor threadPoolExecutor, LinkedBlockingQueue linkedBlockingQueue, SharedRollingFileAppender sharedRollingFileAppender) {
        this(string, (Layout<? extends Serializable>)layout, filter, sharedRollingFileManager, string2, string3, bl, bl2, advertiser, propertyArray, reentrantFileLock, threadPoolExecutor, linkedBlockingQueue);
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<SharedRollingFileAppender> {
        @PluginBuilderAttribute
        private String fileName;
        @PluginBuilderAttribute
        @Required
        private String filePattern;
        @PluginBuilderAttribute
        private boolean append = true;
        @PluginBuilderAttribute
        private boolean locking;
        @PluginElement(value="Policy")
        @Required
        private TriggeringPolicy policy;
        @PluginElement(value="Strategy")
        private RolloverStrategy strategy;
        @PluginBuilderAttribute
        private boolean advertise;
        @PluginBuilderAttribute
        private String advertiseUri;
        @PluginBuilderAttribute
        private boolean createOnDemand;
        @PluginBuilderAttribute
        private String filePermissions;
        @PluginBuilderAttribute
        private String fileOwner;
        @PluginBuilderAttribute
        private String fileGroup;
        @PluginBuilderAttribute
        private String fileLock;
        @PluginBuilderAttribute
        private String resourceLock;
        @PluginBuilderAttribute
        private String messageQueueSize = "1000";
        @PluginBuilderAttribute
        private String writerThreadKeepAliveTimeSec = "3";

        public SharedRollingFileAppender build() {
            boolean isBufferedIo = this.isBufferedIo();
            int bufferSize = this.getBufferSize();
            if (this.getName() == null) {
                LOGGER.error("RollingFileAppender '{}': No name provided.", (Object)this.getName());
                return null;
            }
            if (!isBufferedIo && bufferSize > 0) {
                LOGGER.warn("RollingFileAppender '{}': The bufferSize is set to {} but bufferedIO is not true", (Object)this.getName(), (Object)bufferSize);
            }
            if (this.filePattern == null) {
                LOGGER.error("RollingFileAppender '{}': No file name pattern provided.", (Object)this.getName());
                return null;
            }
            if (this.policy == null) {
                LOGGER.error("RollingFileAppender '{}': No TriggeringPolicy provided.", (Object)this.getName());
                return null;
            }
            if (this.strategy == null) {
                this.strategy = this.fileName != null ? DefaultRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build() : DirectWriteRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build();
            } else if (this.fileName == null && !(this.strategy instanceof DirectFileRolloverStrategy)) {
                LOGGER.error("RollingFileAppender '{}': When no file name is provided a {} must be configured", (Object)this.getName(), (Object)DirectFileRolloverStrategy.class.getSimpleName());
                return null;
            }
            ReentrantFileLock lock = this.newReentrantFileLock(this.fileLock, this.resourceLock);
            lock.lock();
            try {
                Layout layout = this.getOrCreateLayout();
                SharedRollingFileManager manager = SharedRollingFileManager.getFileManager(this.fileName, this.filePattern, this.append, isBufferedIo, this.policy, this.strategy, this.advertiseUri, (Layout<? extends Serializable>)layout, bufferSize, this.isImmediateFlush(), this.createOnDemand, this.filePermissions, this.fileOwner, this.fileGroup, this.getConfiguration());
                if (manager == null) {
                    return null;
                }
                manager.initialize();
                manager.closeOutputStream();
                int keepAliveTimeSec = Integer.parseInt(this.writerThreadKeepAliveTimeSec);
                ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, (long)(keepAliveTimeSec == 0 ? Integer.MAX_VALUE : keepAliveTimeSec), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new BasicThreadFactory.Builder().daemon(keepAliveTimeSec == 0).namingPattern(SharedRollingFileAppender.class.getSimpleName()).build());
                SharedRollingFileAppender sharedRollingFileAppender = new SharedRollingFileAppender(this.getName(), layout, this.getFilter(), manager, this.fileName, this.filePattern, this.isIgnoreExceptions(), this.isImmediateFlush(), this.advertise ? this.getConfiguration().getAdvertiser() : null, this.getPropertyArray(), lock, executor, new LinkedBlockingQueue(Integer.parseInt(this.messageQueueSize)), null);
                return sharedRollingFileAppender;
            }
            finally {
                lock.unlock();
            }
        }

        private ReentrantFileLock newReentrantFileLock(String fileLock, String resourceLock) {
            if (fileLock != null) {
                return ReentrantFileLock.newReentrantFileLockFactory(fileLock).newLock(this.fileName);
            }
            if (resourceLock != null) {
                return ReentrantFileLock.newReentrantResourceLockFactory(resourceLock).newLock(this.fileName);
            }
            throw new IllegalStateException("Please specify fileLock or resourceLock to initialize SharedRollingFileAppender");
        }

        public String getAdvertiseUri() {
            return this.advertiseUri;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isAdvertise() {
            return this.advertise;
        }

        public boolean isAppend() {
            return this.append;
        }

        public boolean isCreateOnDemand() {
            return this.createOnDemand;
        }

        public boolean isLocking() {
            return this.locking;
        }

        public String getFilePermissions() {
            return this.filePermissions;
        }

        public String getFileOwner() {
            return this.fileOwner;
        }

        public String getFileGroup() {
            return this.fileGroup;
        }

        public B withAdvertise(boolean advertise) {
            this.advertise = advertise;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withAdvertiseUri(String advertiseUri) {
            this.advertiseUri = advertiseUri;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withAppend(boolean append) {
            this.append = append;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFileName(String fileName) {
            this.fileName = fileName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withCreateOnDemand(boolean createOnDemand) {
            this.createOnDemand = createOnDemand;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withLocking(boolean locking) {
            this.locking = locking;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getFilePattern() {
            return this.filePattern;
        }

        public TriggeringPolicy getPolicy() {
            return this.policy;
        }

        public RolloverStrategy getStrategy() {
            return this.strategy;
        }

        public B withFilePattern(String filePattern) {
            this.filePattern = filePattern;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withPolicy(TriggeringPolicy policy) {
            this.policy = policy;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withStrategy(RolloverStrategy strategy) {
            this.strategy = strategy;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFilePermissions(String filePermissions) {
            this.filePermissions = filePermissions;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFileOwner(String fileOwner) {
            this.fileOwner = fileOwner;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFileGroup(String fileGroup) {
            this.fileGroup = fileGroup;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFileLock(String FileLock2) {
            this.fileLock = FileLock2;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withResourceLock(String resourceLock) {
            this.resourceLock = resourceLock;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withMessageQueueSize(String messageQueueSize) {
            this.messageQueueSize = messageQueueSize;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withWriterThreadKeepAliveTimeSec(String writerThreadKeepAliveTimeSec) {
            this.writerThreadKeepAliveTimeSec = writerThreadKeepAliveTimeSec;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

