/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ConfigurationFactoryData;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.FileUtils;

class SharedRollingFileManager
extends RollingFileManager {
    private static final FileTime EPOCH = FileTime.fromMillis(0L);
    private static SharedRollingFileManagerFactory factory = new SharedRollingFileManagerFactory();
    private final Semaphore rolloverSemaphore;

    public static SharedRollingFileManager getFileManager(String fileName, String pattern, boolean append, boolean bufferedIO, TriggeringPolicy policy, RolloverStrategy strategy, String advertiseURI, Layout<? extends Serializable> layout, int bufferSize, boolean immediateFlush, boolean createOnDemand, String filePermissions, String fileOwner, String fileGroup, Configuration configuration) {
        if (strategy instanceof DirectWriteRolloverStrategy && fileName != null) {
            LOGGER.error("The fileName attribute must not be specified with the DirectWriteRolloverStrategy");
            return null;
        }
        String name = fileName == null ? pattern : fileName;
        return (SharedRollingFileManager)SharedRollingFileManager.narrow(SharedRollingFileManager.class, (AbstractManager)SharedRollingFileManager.getManager((String)name, (Object)((Object)new FactoryData(fileName, pattern, append, bufferedIO, policy, strategy, advertiseURI, layout, bufferSize, immediateFlush, createOnDemand, filePermissions, fileOwner, fileGroup, configuration)), (ManagerFactory)factory));
    }

    private static long initialFileTime(File file) {
        Path path = file.toPath();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                FileTime fileTime = attrs.creationTime();
                if (fileTime.compareTo(EPOCH) > 0) {
                    LOGGER.debug("Returning file creation time for {}", (Object)file.getAbsolutePath());
                    return fileTime.toMillis();
                }
                LOGGER.info("Unable to obtain file creation time for " + file.getAbsolutePath());
            }
            catch (Exception ex) {
                LOGGER.info("Unable to calculate file creation time for " + file.getAbsolutePath() + ": " + ex.getMessage());
            }
        }
        return file.lastModified();
    }

    protected SharedRollingFileManager(LoggerContext loggerContext, String fileName, String pattern, OutputStream os, boolean append, boolean createOnDemand, long size, long initialTime, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String advertiseURI, Layout<? extends Serializable> layout, String filePermissions, String fileOwner, String fileGroup, boolean writeHeader, ByteBuffer buffer) {
        super(loggerContext, fileName, pattern, os, append, createOnDemand, size, initialTime, triggeringPolicy, rolloverStrategy, advertiseURI, layout, filePermissions, fileOwner, fileGroup, writeHeader, buffer);
        try {
            Field semaphoreField = RollingFileManager.class.getDeclaredField("semaphore");
            semaphoreField.setAccessible(true);
            this.rolloverSemaphore = (Semaphore)semaphoreField.get((Object)this);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException("Cannot initialize file manager", e);
        }
    }

    public boolean closeOutputStream() {
        return super.closeOutputStream();
    }

    public void openOutputStream() throws IOException {
        this.setOutputStream(this.createOutputStream());
    }

    public void updateData(Object data) {
        FactoryData factoryData = (FactoryData)((Object)data);
        this.setRolloverStrategy(factoryData.getRolloverStrategy());
        this.setPatternProcessor(new PatternProcessor(factoryData.getPattern(), this.getPatternProcessor()));
        this.setTriggeringPolicy(factoryData.getTriggeringPolicy());
    }

    public void awaitAsyncRollover() {
        try {
            this.rolloverSemaphore.acquire();
            this.rolloverSemaphore.release();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static class FactoryData
    extends ConfigurationFactoryData {
        private final String fileName;
        private final String pattern;
        private final boolean append;
        private final boolean bufferedIO;
        private final int bufferSize;
        private final boolean immediateFlush;
        private final boolean createOnDemand;
        private final TriggeringPolicy policy;
        private final RolloverStrategy strategy;
        private final String advertiseURI;
        private final Layout<? extends Serializable> layout;
        private final String filePermissions;
        private final String fileOwner;
        private final String fileGroup;

        public FactoryData(String fileName, String pattern, boolean append, boolean bufferedIO, TriggeringPolicy policy, RolloverStrategy strategy, String advertiseURI, Layout<? extends Serializable> layout, int bufferSize, boolean immediateFlush, boolean createOnDemand, String filePermissions, String fileOwner, String fileGroup, Configuration configuration) {
            super(configuration);
            this.fileName = fileName;
            this.pattern = pattern;
            this.append = append;
            this.bufferedIO = bufferedIO;
            this.bufferSize = bufferSize;
            this.policy = policy;
            this.strategy = strategy;
            this.advertiseURI = advertiseURI;
            this.layout = layout;
            this.immediateFlush = immediateFlush;
            this.createOnDemand = createOnDemand;
            this.filePermissions = filePermissions;
            this.fileOwner = fileOwner;
            this.fileGroup = fileGroup;
        }

        public TriggeringPolicy getTriggeringPolicy() {
            return this.policy;
        }

        public RolloverStrategy getRolloverStrategy() {
            return this.strategy;
        }

        public String getPattern() {
            return this.pattern;
        }
    }

    private static class SharedRollingFileManagerFactory
    implements ManagerFactory<SharedRollingFileManager, FactoryData> {
        private SharedRollingFileManagerFactory() {
        }

        public SharedRollingFileManager createManager(String name, FactoryData data) {
            long size = 0L;
            File file = null;
            if (data.fileName != null) {
                file = new File(data.fileName);
                try {
                    FileUtils.makeParentDirs((File)file);
                    boolean created = data.createOnDemand ? false : file.createNewFile();
                    LOGGER.trace("New file '{}' created = {}", (Object)name, (Object)created);
                }
                catch (IOException ioe) {
                    LOGGER.error("Unable to create file " + name, (Throwable)ioe);
                    return null;
                }
                size = data.append ? file.length() : 0L;
            }
            try {
                int actualSize = data.bufferedIO ? data.bufferSize : Constants.ENCODER_BYTE_BUFFER_SIZE;
                ByteBuffer buffer = ByteBuffer.wrap(new byte[actualSize]);
                FileOutputStream os = data.createOnDemand || data.fileName == null ? null : new FileOutputStream(data.fileName, data.append);
                long initialTime = file == null || !file.exists() ? 0L : SharedRollingFileManager.initialFileTime(file);
                boolean writeHeader = file != null && file.exists() && file.length() == 0L;
                SharedRollingFileManager rm = new SharedRollingFileManager(data.getLoggerContext(), data.fileName, data.pattern, os, data.append, data.createOnDemand, size, initialTime, data.policy, data.strategy, data.advertiseURI, (Layout<? extends Serializable>)data.layout, data.filePermissions, data.fileOwner, data.fileGroup, writeHeader, buffer);
                if (os != null && rm.isAttributeViewEnabled()) {
                    rm.defineAttributeView(file.toPath());
                }
                return rm;
            }
            catch (IOException ex) {
                LOGGER.error("RollingFileManager (" + name + ") " + ex, (Throwable)ex);
                return null;
            }
        }
    }
}

