/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert.util;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public final class JmxUtils {
    private JmxUtils() {
    }

    public static <T> T newJmxClient(Class<T> clazz, String objectName, String serviceUrl) {
        return JmxUtils.newJmxClient(clazz, objectName, serviceUrl, null, null);
    }

    public static <T> T newJmxClient(Class<T> clazz, String objectName, String serviceUrl, String user, String pass) {
        try {
            JMXServiceURL jmxServiceUrl = new JMXServiceURL(serviceUrl);
            ImmutableMap env = user == null ? null : ImmutableMap.of((Object)"jmx.remote.credentials", (Object)new String[]{user, pass});
            JMXConnector jmxc = JMXConnectorFactory.connect(jmxServiceUrl, env);
            MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
            ObjectName mbeanName = new ObjectName(objectName);
            return JMX.newMBeanProxy(mbsc, mbeanName, clazz, true);
        }
        catch (IOException | MalformedObjectNameException e) {
            throw new RuntimeException("Can not create client for remote JMX " + serviceUrl, e);
        }
    }

    /*
     * Loose catch block
     */
    public static <I> ObjectInstance registerMBean(String objName, I implementation, Class<I> mbeanInterface) {
        int counter = 0;
        Object uniqueSuffix = "";
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        while (true) {
            try {
                ObjectName name = new ObjectName(objName + (String)uniqueSuffix);
                StandardMBean mbean = new StandardMBean(implementation, mbeanInterface);
                return mbs.registerMBean(mbean, name);
            }
            catch (InstanceAlreadyExistsException e) {
                uniqueSuffix = "" + ++counter;
                continue;
            }
            break;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void unregisterMBean(String objName) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName(objName);
            mbs.unregisterMBean(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

