/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert.util;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.droolsassert.util.AlphanumComparator;
import org.droolsassert.util.JmxUtils;
import org.droolsassert.util.Stat;
import org.droolsassert.util.StatImpl;

public class PerfStat {
    private static String jmxDomain = System.getProperty("perfstat.domain", "perfstat");
    private static long defaultAggregationPeriodMs = Long.parseLong(System.getProperty("perfstat.aggregationPeriodMs", "4000"));
    private static final ConcurrentHashMap<String, Map<String, StatImpl>> stats = new ConcurrentHashMap();
    private ThreadLocal<StopWatch> stopWatch = ThreadLocal.withInitial(() -> new StopWatch());
    private StatImpl stat;
    private long lastAggregationTimeMs = System.currentTimeMillis();
    private long aggregationPeriodMs;

    public static String getJmxDomain() {
        return jmxDomain;
    }

    public static void setJmxDomain(String jmxDomain) {
        PerfStat.jmxDomain = jmxDomain;
    }

    public static long getDefaultAggregationPeriodMs() {
        return defaultAggregationPeriodMs;
    }

    public static void setDefaultAggregationPeriodMs(long defaultAggregationPeriodMs) {
        PerfStat.defaultAggregationPeriodMs = defaultAggregationPeriodMs;
    }

    public static Stat getPerfStat(String name) {
        return PerfStat.getPerfStat("", name);
    }

    public static Stat getPerfStat(String type, String name) {
        return stats.get(type).get(name);
    }

    public static TreeMap<String, TreeMap<String, StatImpl>> getPerfStat() {
        TreeMap<String, TreeMap<String, StatImpl>> sorted = new TreeMap<String, TreeMap<String, StatImpl>>(AlphanumComparator.ALPHANUM_COMPARATOR);
        stats.entrySet().forEach(e -> {
            TreeMap sortedNames = new TreeMap(AlphanumComparator.ALPHANUM_COMPARATOR);
            sortedNames.putAll((Map)e.getValue());
            sorted.put((String)e.getKey(), sortedNames);
        });
        return sorted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(Map<String, Map<String, StatImpl>> rhsStatsByType) {
        ConcurrentHashMap<String, Map<String, StatImpl>> concurrentHashMap = stats;
        synchronized (concurrentHashMap) {
            for (Map.Entry<String, Map<String, StatImpl>> rhsStatsByName : rhsStatsByType.entrySet()) {
                Map<String, StatImpl> lhsStatsByName = stats.get(rhsStatsByName.getKey());
                if (lhsStatsByName == null) {
                    lhsStatsByName = new ConcurrentHashMap<String, StatImpl>();
                    stats.put(rhsStatsByName.getKey(), lhsStatsByName);
                }
                for (Map.Entry<String, StatImpl> rhsStat : rhsStatsByName.getValue().entrySet()) {
                    StatImpl lhs = lhsStatsByName.get(rhsStat.getKey());
                    StatImpl rhs = rhsStat.getValue();
                    if (lhs == null) {
                        lhsStatsByName.put(rhsStat.getKey(), rhs);
                        continue;
                    }
                    lhs.leapsCount += rhs.leapsCount;
                    lhs.totalTimeNs += rhs.totalTimeNs;
                    if (rhs.minTimeMs < lhs.minTimeMs) {
                        lhs.minTimeMs = rhs.minTimeMs;
                    }
                    if (!(rhs.maxTimeMs > lhs.maxTimeMs)) continue;
                    lhs.maxTimeMs = rhs.maxTimeMs;
                }
            }
        }
    }

    public static void resetAll() {
        stats.values().stream().flatMap(m -> m.values().stream()).forEach(StatImpl::reset);
    }

    public PerfStat(String name) {
        this("", name, defaultAggregationPeriodMs);
    }

    public PerfStat(String type, String name) {
        this(type, name, defaultAggregationPeriodMs);
    }

    public PerfStat(String name, long aggregationPeriodMs) {
        this("", name, aggregationPeriodMs);
    }

    public PerfStat(String type, String name, long aggregationPeriodMs) {
        Map<String, StatImpl> statsByName;
        this.aggregationPeriodMs = aggregationPeriodMs;
        if (type == null) {
            type = "";
        }
        if ((statsByName = stats.get(type)) == null) {
            statsByName = new ConcurrentHashMap<String, StatImpl>();
            stats.put(type, statsByName);
        }
        this.stat = statsByName.get(name);
        if (this.stat == null) {
            this.initStat(type, name);
        }
        this.stat.peersCount.incrementAndGet();
    }

    protected void finalize() throws Throwable {
        this.stat.peersCount.decrementAndGet();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStat(String type, String name) {
        ConcurrentHashMap<String, Map<String, StatImpl>> concurrentHashMap = stats;
        synchronized (concurrentHashMap) {
            Map<String, StatImpl> statsByName = stats.get(type);
            if (statsByName == null) {
                statsByName = new ConcurrentHashMap<String, StatImpl>();
                stats.put(type, statsByName);
            }
            this.stat = statsByName.get(name);
            if (this.stat == null) {
                this.stat = new StatImpl(type, name);
                statsByName.put(name, this.stat);
                StringBuilder objName = new StringBuilder(jmxDomain);
                objName.append(":");
                if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{type})) {
                    objName.append("type=");
                    objName.append(this.quoteIfNeeded(type));
                    objName.append(",");
                }
                objName.append("name=");
                objName.append(this.quoteIfNeeded(name));
                JmxUtils.registerMBean(objName.toString(), this.stat, Stat.class);
            }
        }
    }

    private String quoteIfNeeded(String name) {
        return StringUtils.containsAny((CharSequence)name, (char[])new char[]{'\n', '\\', '\"', '*', '?', ':'}) ? ObjectName.quote(name) : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerfStat start() {
        if (this.stopWatch.get().isStarted()) {
            StatImpl statImpl = this.stat;
            synchronized (statImpl) {
                ++this.stat.failedLeapsCount;
            }
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (this.stat.leapsCountSample > 0L && currentTimeMillis > this.lastAggregationTimeMs + this.aggregationPeriodMs) {
            StatImpl statImpl = this.stat;
            synchronized (statImpl) {
                if (this.stat.leapsCountSample > 0L && currentTimeMillis > this.lastAggregationTimeMs + this.aggregationPeriodMs) {
                    this.lastAggregationTimeMs = currentTimeMillis;
                    this.stat.avgTimeSampleMs = PerfStat.round(this.stat.totalTimeSampleNs / (double)this.stat.leapsCountSample);
                    this.stat.leapsCountSample = 0L;
                    this.stat.totalTimeSampleNs = 0.0;
                    this.stat.maxTimeSampleMs = this.stat.maxTimeThresholdMs;
                    this.stat.maxTimeThresholdMs = 0.0;
                    this.stat.minTimeSampleMs = this.stat.minTimeThresholdMs;
                    this.stat.minTimeThresholdMs = 0.0;
                }
            }
        }
        this.stopWatch.get().reset();
        this.stopWatch.get().start();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long stop() {
        this.stopWatch.get().stop();
        long timeNs = this.stopWatch.get().getNanoTime();
        double timeMs = PerfStat.round(timeNs);
        StatImpl statImpl = this.stat;
        synchronized (statImpl) {
            this.stat.leapTimeMs = timeMs;
            this.stat.totalTimeNs += (double)timeNs;
            this.stat.totalTimeSampleNs += (double)timeNs;
            if (timeMs > this.stat.maxTimeMs) {
                this.stat.maxTimeMs = timeMs;
            }
            if (timeMs > this.stat.maxTimeThresholdMs) {
                this.stat.maxTimeThresholdMs = timeMs;
            }
            if (timeMs < this.stat.minTimeMs || this.stat.minTimeMs == 0.0) {
                this.stat.minTimeMs = timeMs;
            }
            if (timeMs < this.stat.minTimeThresholdMs || this.stat.minTimeThresholdMs == 0.0) {
                this.stat.minTimeThresholdMs = timeMs;
            }
            ++this.stat.leapsCount;
            ++this.stat.leapsCountSample;
        }
        return timeNs;
    }

    public void reset() {
        this.stat.reset();
    }

    public StopWatch getStopWatch() {
        return this.stopWatch.get();
    }

    public Stat getStat() {
        return this.stat;
    }

    public String getType() {
        return this.stat.getType();
    }

    public String getName() {
        return this.stat.getName();
    }

    public String getFullName() {
        return this.stat.getFullName();
    }

    static double round(double nanos) {
        double scale = 1000.0;
        double nsInMs = 1000000.0;
        return (double)Math.round(nanos * scale / nsInMs) / scale;
    }

    public String toString() {
        return this.stat.toString();
    }
}

