/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert.util;

import java.util.Comparator;

public class AlphanumComparator
implements Comparator<String> {
    public static final AlphanumComparator ALPHANUM_COMPARATOR = new AlphanumComparator();
    private static char[] upperCaseCache = new char[(int)Math.pow(2.0, 16.0)];
    private boolean nullIsLess;

    public AlphanumComparator() {
    }

    public AlphanumComparator(boolean nullIsLess) {
        this.nullIsLess = nullIsLess;
    }

    @Override
    public int compare(String s1, String s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return this.nullIsLess ? -1 : 1;
        }
        if (s2 == null) {
            return this.nullIsLess ? 1 : -1;
        }
        int i1 = 0;
        int i2 = 0;
        int len1 = s1.length();
        int len2 = s2.length();
        block0: while (i1 != len1) {
            if (i2 == len2) {
                return 1;
            }
            char ch1 = s1.charAt(i1);
            char ch2 = s2.charAt(i2);
            if (this.isDigit(ch1) && this.isDigit(ch2)) {
                int end1;
                while (i1 < len1 && s1.charAt(i1) == '0') {
                    ++i1;
                }
                while (i2 < len2 && s2.charAt(i2) == '0') {
                    ++i2;
                }
                if (i1 != i2) {
                    return i2 - i1;
                }
                int end2 = i2;
                for (end1 = i1; end1 < len1 && this.isDigit(s1.charAt(end1)); ++end1) {
                }
                while (end2 < len2 && this.isDigit(s2.charAt(end2))) {
                    ++end2;
                }
                int diglen1 = end1 - i1;
                int diglen2 = end2 - i2;
                if (diglen1 != diglen2) {
                    return diglen1 - diglen2;
                }
                while (true) {
                    if (i1 >= end1) continue block0;
                    ch1 = s1.charAt(i1);
                    if (ch1 != (ch2 = s2.charAt(i2))) {
                        return ch1 - ch2;
                    }
                    ++i1;
                    ++i2;
                }
            }
            if ((ch1 = this.toUpperCase(ch1)) != (ch2 = this.toUpperCase(ch2))) {
                return ch1 - ch2;
            }
            ++i1;
            ++i2;
        }
        return i2 == len2 ? 0 : -1;
    }

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private char toUpperCase(char ch) {
        char cached = upperCaseCache[ch];
        if (cached == '\u0000') {
            AlphanumComparator.upperCaseCache[ch] = cached = Character.toUpperCase(ch);
        }
        return cached;
    }
}

