/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;

public class PasswordAuthentication
implements AuthenticationMethod {
    private static Logger log = Logger.getLogger(PasswordAuthentication.class);

    public boolean canSelfRegister(Context context, HttpServletRequest request, String email) throws SQLException {
        String domains = ConfigurationManager.getProperty("authentication.password.domain.valid");
        if (domains == null || domains.trim().equals("")) {
            return true;
        }
        String[] options = domains.trim().split(",");
        email = email.trim().toLowerCase();
        for (int i = 0; i < options.length; ++i) {
            String check = options[i].trim().toLowerCase();
            if (!email.endsWith(check)) continue;
            return true;
        }
        return false;
    }

    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        return true;
    }

    public boolean isImplicit() {
        return false;
    }

    public int[] getSpecialGroups(Context context, HttpServletRequest request) {
        return new int[0];
    }

    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        if (username != null && password != null) {
            EPerson eperson = null;
            log.info((Object)LogManager.getHeader(context, "authenticate", "attempting password auth of user=" + username));
            try {
                eperson = EPerson.findByEmail(context, username.toLowerCase());
            }
            catch (AuthorizeException e) {
                // empty catch block
            }
            if (eperson == null) {
                return 4;
            }
            if (!eperson.canLogIn()) {
                return 5;
            }
            if (eperson.getRequireCertificate()) {
                log.warn((Object)LogManager.getHeader(context, "authenticate", "rejecting PasswordAuthentication because " + username + " requires certificate."));
                return 3;
            }
            if (eperson.checkPassword(password)) {
                context.setCurrentUser(eperson);
                log.info((Object)LogManager.getHeader(context, "authenticate", "type=PasswordAuthentication"));
                return 1;
            }
            return 2;
        }
        return 5;
    }

    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        return response.encodeRedirectURL(request.getContextPath() + "/password-login");
    }

    public String loginPageTitle(Context context) {
        return "org.dspace.eperson.PasswordAuthentication.title";
    }
}

