/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.Context;
import org.dspace.eperson.Group;

public class PolicySet {
    public static void main(String[] argv) throws Exception {
        if (argv.length < 6) {
            System.out.println("Args: containerType containerID contentType actionID groupID command");
            System.out.println("container=COLLECTION command = ADD|REPLACE");
            return;
        }
        int containertype = Integer.parseInt(argv[0]);
        int containerID = Integer.parseInt(argv[1]);
        int contenttype = Integer.parseInt(argv[2]);
        int actionID = Integer.parseInt(argv[3]);
        int groupID = Integer.parseInt(argv[4]);
        boolean isReplace = false;
        String command = argv[5];
        if (command.equals("REPLACE")) {
            isReplace = true;
        }
        Context c = new Context();
        c.setIgnoreAuthorization(true);
        PolicySet.setPolicies(c, containertype, containerID, contenttype, actionID, groupID, isReplace, false);
        c.complete();
        System.exit(0);
    }

    public static void setPolicies(Context c, int containerType, int containerID, int contentType, int actionID, int groupID, boolean isReplace, boolean clearOnly) throws SQLException, AuthorizeException {
        block9: {
            ItemIterator i;
            Group group;
            block11: {
                block10: {
                    if (containerType != 3) break block9;
                    Collection collection = Collection.find(c, containerID);
                    group = Group.find(c, groupID);
                    i = collection.getItems();
                    if (contentType != 2) break block10;
                    while (i.hasNext()) {
                        Item myitem = i.next();
                        if (isReplace || clearOnly) {
                            AuthorizeManager.removeAllPolicies(c, myitem);
                        }
                        if (clearOnly) continue;
                        ResourcePolicy rp = ResourcePolicy.create(c);
                        rp.setResource(myitem);
                        rp.setAction(actionID);
                        rp.setGroup(group);
                        rp.update();
                    }
                    break block9;
                }
                if (contentType != 1) break block11;
                while (i.hasNext()) {
                    Item myitem = i.next();
                    Bundle[] bundles = myitem.getBundles();
                    for (int j = 0; j < bundles.length; ++j) {
                        Bundle t = bundles[j];
                        if (isReplace || clearOnly) {
                            AuthorizeManager.removeAllPolicies(c, t);
                        }
                        if (clearOnly) continue;
                        ResourcePolicy rp = ResourcePolicy.create(c);
                        rp.setResource(t);
                        rp.setAction(actionID);
                        rp.setGroup(group);
                        rp.update();
                    }
                }
                break block9;
            }
            if (contentType != 0) break block9;
            while (i.hasNext()) {
                Item myitem = i.next();
                System.out.println("Item " + myitem.getID());
                Bundle[] bundles = myitem.getBundles();
                for (int j = 0; j < bundles.length; ++j) {
                    System.out.println("Bundle " + bundles[j].getID());
                    Bitstream[] bitstreams = bundles[j].getBitstreams();
                    for (int k = 0; k < bitstreams.length; ++k) {
                        Bitstream t = bitstreams[k];
                        if (isReplace || clearOnly) {
                            AuthorizeManager.removeAllPolicies(c, t);
                        }
                        if (clearOnly) continue;
                        ResourcePolicy rp = ResourcePolicy.create(c);
                        rp.setResource(t);
                        rp.setAction(actionID);
                        rp.setGroup(group);
                        rp.update();
                    }
                }
            }
        }
    }
}

