/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.browse.BrowseException;
import org.dspace.browse.IndexBrowse;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;

public class BrowseConsumer
implements Consumer {
    private static Logger log = Logger.getLogger(BrowseConsumer.class);
    private Set<Item> toUpdate = null;

    public void initialize() throws Exception {
    }

    public void consume(Context ctx, Event event) throws Exception {
        if (this.toUpdate == null) {
            this.toUpdate = new HashSet<Item>();
        }
        DSpaceObject subj = event.getSubject(ctx);
        int st = event.getSubjectType();
        int et = event.getEventType();
        switch (st) {
            case 2: {
                this.toUpdate.add((Item)subj);
                break;
            }
            case 3: {
                Item obj;
                if (event.getObjectType() != 2 || et != 8 && et != 16 || (obj = (Item)event.getObject(ctx)) == null) break;
                this.toUpdate.add(obj);
                break;
            }
            default: {
                log.warn((Object)("consume() got unrecognized event: " + event.toString()));
            }
        }
    }

    public void end(Context ctx) throws Exception {
        if (this.toUpdate != null) {
            for (Item i : this.toUpdate) {
                try {
                    IndexBrowse ib = new IndexBrowse(ctx);
                    ib.indexItem(i);
                }
                catch (BrowseException e) {
                    log.error((Object)"caught exception: ", (Throwable)e);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Updated browse indices for Item id=" + String.valueOf(i.getID()) + ", hdl=" + i.getHandle()));
            }
            ctx.getDBConnection().commit();
        }
        this.toUpdate = null;
    }

    public void finish(Context ctx) {
    }
}

