/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.browse.BrowseException;
import org.dspace.core.ConfigurationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortOption {
    public static final String ASCENDING = "ASC";
    public static final String DESCENDING = "DESC";
    private int number;
    private String name;
    private String metadata;
    private String type;
    private String[] mdBits;
    private String defaultOrder;
    private static Set<SortOption> sortOptionsSet = null;
    private static Map<Integer, SortOption> sortOptionsMap = null;

    public SortOption(int number, String name, String md, String type) throws BrowseException {
        this.name = name;
        this.type = type;
        this.metadata = md;
        this.number = number;
        this.defaultOrder = ASCENDING;
        this.generateMdBits();
    }

    public SortOption(int number, String name, String md, String type, String defaultOrder) throws BrowseException {
        this.name = name;
        this.type = type;
        this.metadata = md;
        this.number = number;
        this.defaultOrder = DESCENDING.equalsIgnoreCase(defaultOrder) ? DESCENDING : ASCENDING;
        this.generateMdBits();
    }

    public SortOption(int number, String definition) throws BrowseException {
        this.number = number;
        String rx = "(\\w+):([\\w\\.\\*]+):(\\w+):?(\\w*)";
        Pattern pattern = Pattern.compile(rx);
        Matcher matcher = pattern.matcher(definition);
        if (!matcher.matches()) {
            throw new BrowseException("Sort Order configuration is not valid: webui.browse.sort-order." + number + " = " + definition);
        }
        this.name = matcher.group(1);
        this.metadata = matcher.group(2);
        this.type = matcher.group(3);
        if (matcher.groupCount() > 3) {
            this.defaultOrder = matcher.group(4);
        }
        this.defaultOrder = DESCENDING.equalsIgnoreCase(this.defaultOrder) ? DESCENDING : ASCENDING;
        this.generateMdBits();
    }

    public String getDefaultOrder() {
        return this.defaultOrder;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String[] getMdBits() {
        return this.mdBits;
    }

    public void generateMdBits() throws BrowseException {
        try {
            this.mdBits = this.interpretField(this.metadata, null);
        }
        catch (IOException e) {
            throw new BrowseException(e);
        }
    }

    public String[] interpretField(String mfield, String init) throws IOException {
        StringTokenizer sta = new StringTokenizer(mfield, ".");
        String[] field = new String[]{init, init, init};
        int i = 0;
        while (sta.hasMoreTokens()) {
            field[i++] = sta.nextToken();
        }
        if (field[0] == null || field[1] == null) {
            throw new IOException("at least a schema and element be specified in configuration.  You supplied: " + mfield);
        }
        return field;
    }

    public boolean isDate() {
        return this.type != null && "date".equals(this.type);
    }

    public boolean isDefault() {
        return this.number == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, SortOption> getSortOptionsMap() throws BrowseException {
        if (sortOptionsMap != null) {
            return sortOptionsMap;
        }
        Map<Integer, SortOption> map = sortOptionsMap = new HashMap<Integer, SortOption>();
        synchronized (map) {
            for (SortOption so : SortOption.getSortOptions()) {
                sortOptionsMap.put(new Integer(so.getNumber()), so);
            }
        }
        return sortOptionsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<SortOption> getSortOptions() throws BrowseException {
        if (sortOptionsSet != null) {
            return sortOptionsSet;
        }
        Set<SortOption> set = sortOptionsSet = new HashSet<SortOption>();
        synchronized (set) {
            Enumeration en = ConfigurationManager.propertyNames();
            String rx = "webui\\.browse\\.sort-option\\.(\\d+)";
            Pattern pattern = Pattern.compile(rx);
            while (en.hasMoreElements()) {
                String property = (String)en.nextElement();
                Matcher matcher = pattern.matcher(property);
                if (!matcher.matches()) continue;
                int number = Integer.parseInt(matcher.group(1));
                String option = ConfigurationManager.getProperty(property);
                SortOption so = new SortOption(number, option);
                sortOptionsSet.add(so);
            }
        }
        return sortOptionsSet;
    }

    public static SortOption getSortOption(int number) throws BrowseException {
        for (SortOption so : SortOption.getSortOptions()) {
            if (so.getNumber() != number) continue;
            return so;
        }
        return null;
    }

    public static SortOption getDefaultSortOption() throws BrowseException {
        Iterator<SortOption> i$ = SortOption.getSortOptions().iterator();
        if (i$.hasNext()) {
            SortOption so = i$.next();
            return so;
        }
        return null;
    }
}

