/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.checker.BitstreamInfo;
import org.dspace.checker.ChecksumResultDAO;
import org.dspace.checker.ChecksumResultsCollector;
import org.dspace.core.I18N;

public class ResultsLogger
implements ChecksumResultsCollector {
    private static final Logger LOG = Logger.getLogger(ResultsLogger.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
    Date startDate = null;
    private ChecksumResultDAO resultDAO;

    private ResultsLogger() {
    }

    public ResultsLogger(Date startDt) {
        this.resultDAO = new ChecksumResultDAO();
        LOG.info((Object)(this.msg("run-start-time") + ": " + DATE_FORMAT.format(startDt)));
    }

    private String msg(String key) {
        return I18N.message(key, ResultsLogger.class);
    }

    public void collect(BitstreamInfo info) {
        LOG.info((Object)"******************************************************");
        LOG.info((Object)(this.msg("bitstream-id") + ": " + info.getBitstreamId()));
        LOG.info((Object)(this.msg("bitstream-info-found") + ": " + info.getInfoFound()));
        LOG.info((Object)(this.msg("bitstream-marked-deleted") + ": " + info.getDeleted()));
        LOG.info((Object)(this.msg("bitstream-found") + ": " + info.getBitstreamFound()));
        LOG.info((Object)(this.msg("to-be-processed") + ": " + info.getToBeProcessed()));
        LOG.info((Object)(this.msg("internal-id") + ": " + info.getInternalId()));
        LOG.info((Object)(this.msg("name") + ": " + info.getName()));
        LOG.info((Object)(this.msg("store-number") + ": " + info.getStoreNumber()));
        LOG.info((Object)(this.msg("size") + ": " + info.getSize()));
        LOG.info((Object)(this.msg("bitstream-format") + ": " + info.getBitstreamFormatId()));
        LOG.info((Object)(this.msg("user-format-description") + ": " + info.getUserFormatDescription()));
        LOG.info((Object)(this.msg("source") + ": " + info.getSource()));
        LOG.info((Object)(this.msg("checksum-algorithm") + ": " + info.getChecksumAlgorithm()));
        LOG.info((Object)(this.msg("previous-checksum") + ": " + info.getStoredChecksum()));
        LOG.info((Object)(this.msg("previous-checksum-date") + ": " + (info.getProcessEndDate() != null ? DATE_FORMAT.format(info.getProcessEndDate()) : "unknown")));
        LOG.info((Object)(this.msg("new-checksum") + ": " + info.getCalculatedChecksum()));
        LOG.info((Object)(this.msg("checksum-comparison-result") + ": " + this.resultDAO.getChecksumCheckStr(info.getChecksumCheckResult())));
        LOG.info((Object)"\n\n");
    }
}

