/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import org.dspace.browse.BrowseOrder;
import org.dspace.content.DCValue;
import org.dspace.content.Item;

public class ItemComparator
implements Comparator {
    private String element;
    private String qualifier;
    private String language;
    private boolean max;

    public ItemComparator(String element, String qualifier, String language, boolean max) {
        this.element = element;
        this.qualifier = qualifier;
        this.language = language;
        this.max = max;
    }

    public int compare(Object first, Object second) {
        if (!(first instanceof Item) || !(second instanceof Item)) {
            throw new IllegalArgumentException("Arguments must be Items");
        }
        String firstValue = this.getValue((Item)first);
        String secondValue = this.getValue((Item)second);
        if (firstValue == null && secondValue == null) {
            return 0;
        }
        if (firstValue != null && secondValue == null) {
            return 1;
        }
        if (firstValue == null && secondValue != null) {
            return -1;
        }
        return firstValue.compareTo(secondValue);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemComparator)) {
            return false;
        }
        ItemComparator other = (ItemComparator)obj;
        return this._equals(this.element, other.element) && this._equals(this.qualifier, other.qualifier) && this._equals(this.language, other.language) && this.max == other.max;
    }

    private boolean _equals(String first, String second) {
        if (first == null && second == null) {
            return true;
        }
        if (first != null && second == null) {
            return false;
        }
        if (first == null && second != null) {
            return false;
        }
        return first.equals(second);
    }

    private String getValue(Item item) {
        DCValue[] dcvalues = item.getDC(this.element, this.qualifier, this.language);
        if (dcvalues.length == 0) {
            return null;
        }
        if (dcvalues.length == 1) {
            return this.normalizeTitle(dcvalues[0]);
        }
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        for (int i = 0; i < dcvalues.length; ++i) {
            String value = dcvalues[i].value;
            if (value == null) continue;
            values.put(value, new Integer(i));
        }
        if (values.size() == 0) {
            return null;
        }
        Set valueSet = values.keySet();
        String chosen = this.max ? (String)Collections.max(valueSet) : (String)Collections.min(valueSet);
        int index = (Integer)values.get(chosen);
        return this.normalizeTitle(dcvalues[index]);
    }

    private String normalizeTitle(DCValue value) {
        if (!"title".equals(this.element)) {
            return value.value;
        }
        return BrowseOrder.makeSortString(value.value, value.language, "title");
    }
}

