/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class MetadataSchema {
    private static Logger log = Logger.getLogger(MetadataSchema.class);
    public static final int DC_SCHEMA_ID = 1;
    public static final String DC_SCHEMA = "dc";
    private TableRow row;
    private int schemaID;
    private String namespace;
    private String name;
    private static HashMap id2schema = null;
    private static HashMap name2schema = null;

    public MetadataSchema() {
    }

    public MetadataSchema(int schemaID, String namespace, String name) {
        this.schemaID = schemaID;
        this.namespace = namespace;
        this.name = name;
    }

    public MetadataSchema(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    public MetadataSchema(TableRow row) {
        if (row != null) {
            this.schemaID = row.getIntColumn("metadata_schema_id");
            this.namespace = row.getStringColumn("namespace");
            this.name = row.getStringColumn("short_id");
            this.row = row;
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSchemaID() {
        return this.schemaID;
    }

    public void create(Context context) throws SQLException, AuthorizeException, NonUniqueMetadataException {
        if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only administrators may modify the metadata registry");
        }
        if (!this.uniqueShortName(context, this.name)) {
            throw new NonUniqueMetadataException("Please make the name " + this.name + " unique");
        }
        if (!this.uniqueNamespace(context, this.namespace)) {
            throw new NonUniqueMetadataException("Please make the namespace " + this.namespace + " unique");
        }
        this.row = DatabaseManager.create(context, "MetadataSchemaRegistry");
        this.row.setColumn("namespace", this.namespace);
        this.row.setColumn("short_id", this.name);
        DatabaseManager.update(context, this.row);
        MetadataSchema.decache();
        this.schemaID = this.row.getIntColumn("metadata_schema_id");
        log.info((Object)LogManager.getHeader(context, "create_metadata_schema", "metadata_schema_id=" + this.row.getIntColumn("metadata_schema_id")));
    }

    public static MetadataSchema findByNamespace(Context context, String namespace) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "MetadataSchemaRegistry", "SELECT * FROM MetadataSchemaRegistry WHERE namespace= ? ", namespace);
        TableRow row = null;
        if (tri.hasNext()) {
            row = tri.next();
        }
        tri.close();
        if (row == null) {
            return null;
        }
        return new MetadataSchema(row);
    }

    public void update(Context context) throws SQLException, AuthorizeException, NonUniqueMetadataException {
        if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only administrators may modify the metadata registry");
        }
        if (!this.uniqueShortName(context, this.name)) {
            throw new NonUniqueMetadataException("Please make the name " + this.name + " unique");
        }
        if (!this.uniqueNamespace(context, this.namespace)) {
            throw new NonUniqueMetadataException("Please make the namespace " + this.namespace + " unique");
        }
        this.row.setColumn("namespace", this.getNamespace());
        this.row.setColumn("short_id", this.getName());
        DatabaseManager.update(context, this.row);
        MetadataSchema.decache();
        log.info((Object)LogManager.getHeader(context, "update_metadata_schema", "metadata_schema_id=" + this.getSchemaID() + "namespace=" + this.getNamespace() + "name=" + this.getName()));
    }

    public void delete(Context context) throws SQLException, AuthorizeException {
        if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only administrators may modify the metadata registry");
        }
        log.info((Object)LogManager.getHeader(context, "delete_metadata_schema", "metadata_schema_id=" + this.getSchemaID()));
        DatabaseManager.delete(context, this.row);
    }

    public static MetadataSchema[] findAll(Context context) throws SQLException {
        ArrayList<MetadataSchema> schemas = new ArrayList<MetadataSchema>();
        TableRowIterator tri = DatabaseManager.queryTable(context, "MetadataSchemaRegistry", "SELECT * FROM MetadataSchemaRegistry ORDER BY metadata_schema_id", new Object[0]);
        while (tri.hasNext()) {
            schemas.add(new MetadataSchema(tri.next()));
        }
        tri.close();
        MetadataSchema[] typeArray = new MetadataSchema[schemas.size()];
        return schemas.toArray(typeArray);
    }

    private boolean uniqueNamespace(Context context, String namespace) throws SQLException {
        Connection con = context.getDBConnection();
        TableRow reg = DatabaseManager.row("MetadataSchemaRegistry");
        String query = "SELECT COUNT(*) FROM " + reg.getTable() + " " + "WHERE metadata_schema_id != ? " + "AND namespace= ? ";
        PreparedStatement statement = con.prepareStatement(query);
        statement.setInt(1, this.schemaID);
        statement.setString(2, namespace);
        ResultSet rs = statement.executeQuery();
        int count = 0;
        if (rs.next()) {
            count = rs.getInt(1);
        }
        return count == 0;
    }

    private boolean uniqueShortName(Context context, String name) throws SQLException {
        Connection con = context.getDBConnection();
        TableRow reg = DatabaseManager.row("MetadataSchemaRegistry");
        String query = "SELECT COUNT(*) FROM " + reg.getTable() + " " + "WHERE metadata_schema_id != ? " + "AND short_id = ? ";
        PreparedStatement statement = con.prepareStatement(query);
        statement.setInt(1, this.schemaID);
        statement.setString(2, name);
        ResultSet rs = statement.executeQuery();
        int count = 0;
        if (rs.next()) {
            count = rs.getInt(1);
        }
        return count == 0;
    }

    public static MetadataSchema find(Context context, int id) throws SQLException {
        MetadataSchema.initCache(context);
        Integer iid = new Integer(id);
        if (!id2schema.containsKey(iid)) {
            return null;
        }
        return (MetadataSchema)id2schema.get(iid);
    }

    public static MetadataSchema find(Context context, String shortName) throws SQLException {
        if (shortName == null) {
            return null;
        }
        MetadataSchema.initCache(context);
        if (!name2schema.containsKey(shortName)) {
            return null;
        }
        return (MetadataSchema)name2schema.get(shortName);
    }

    private static void decache() {
        id2schema = null;
        name2schema = null;
    }

    private static void initCache(Context context) throws SQLException {
        if (id2schema != null && name2schema != null) {
            return;
        }
        log.info((Object)"Loading schema cache for fast finds");
        id2schema = new HashMap();
        name2schema = new HashMap();
        TableRowIterator tri = DatabaseManager.queryTable(context, "MetadataSchemaRegistry", "SELECT * from MetadataSchemaRegistry", new Object[0]);
        while (tri.hasNext()) {
            TableRow row = tri.next();
            MetadataSchema s = new MetadataSchema(row);
            id2schema.put(new Integer(s.schemaID), s);
            name2schema.put(s.name, s);
        }
        tri.close();
    }
}

