/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.PluginConfigurationError;
import org.dspace.core.PluginInstantiationException;
import org.dspace.core.SelfNamedPlugin;

public class PluginManager {
    private static Logger log = Logger.getLogger(PluginManager.class);
    private static final String SINGLE_PREFIX = "plugin.single.";
    private static final String SEQUENCE_PREFIX = "plugin.sequence.";
    private static final String NAMED_PREFIX = "plugin.named.";
    private static final String SELFNAMED_PREFIX = "plugin.selfnamed.";
    private static final String REUSABLE_PREFIX = "plugin.reusable.";
    private static final String SEP = "\u001c";
    private static HashMap cacheMeCache = new HashMap();
    private static HashMap sequenceConfig = new HashMap();
    private static HashMap anonymousInstanceCache = new HashMap();
    private static HashMap namedPluginClasses = new HashMap();
    private static HashMap namedInstanceCache = new HashMap();

    private static boolean cacheMe(Class implClass) {
        if (cacheMeCache.containsKey(implClass)) {
            return (Boolean)cacheMeCache.get(implClass);
        }
        String key = REUSABLE_PREFIX + implClass.getName();
        boolean reusable = ConfigurationManager.getBooleanProperty(key, true);
        cacheMeCache.put(implClass, new Boolean(reusable));
        return reusable;
    }

    public static Object getSinglePlugin(Class interfaceClass) throws PluginConfigurationError, PluginInstantiationException {
        String iname = interfaceClass.getName();
        String classname = ConfigurationManager.getProperty(SINGLE_PREFIX + iname);
        if (classname != null) {
            return PluginManager.getAnonymousPlugin(classname.trim());
        }
        throw new PluginConfigurationError("No Single Plugin configured for interface \"" + iname + "\"");
    }

    public static Object[] getPluginSequence(Class intfc) throws PluginInstantiationException {
        String iname = intfc.getName();
        String[] classname = null;
        if (!sequenceConfig.containsKey(iname)) {
            String val = ConfigurationManager.getProperty(SEQUENCE_PREFIX + iname);
            if (val == null) {
                log.warn((Object)("No Configuration entry found for Sequence Plugin interface=" + iname));
                return new Object[0];
            }
            classname = val.trim().split("\\s*,\\s*");
            sequenceConfig.put(iname, classname);
        } else {
            classname = (String[])sequenceConfig.get(iname);
        }
        Object[] result = (Object[])Array.newInstance(intfc, classname.length);
        for (int i = 0; i < classname.length; ++i) {
            log.debug((Object)("Adding Sequence plugin for interface= " + iname + ", class=" + classname[i]));
            result[i] = PluginManager.getAnonymousPlugin(classname[i]);
        }
        return result;
    }

    private static Object getAnonymousPlugin(String classname) throws PluginInstantiationException {
        try {
            Class<?> pluginClass = Class.forName(classname);
            if (PluginManager.cacheMe(pluginClass)) {
                Object cached = anonymousInstanceCache.get(pluginClass);
                if (cached == null) {
                    cached = pluginClass.newInstance();
                    anonymousInstanceCache.put(pluginClass, cached);
                }
                return cached;
            }
            return pluginClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new PluginInstantiationException("Cannot load plugin class: " + e.toString(), e);
        }
        catch (InstantiationException e) {
            throw new PluginInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            throw new PluginInstantiationException(e);
        }
    }

    private static void configureNamedPlugin(String iname) throws ClassNotFoundException {
        int found = 0;
        if (!namedPluginClasses.containsKey(iname)) {
            String selfNamedVal;
            String namedVal = ConfigurationManager.getProperty(NAMED_PREFIX + iname);
            if (namedVal != null) {
                namedVal = namedVal.trim();
                log.debug((Object)("Got Named configuration for interface=" + iname + ", config=" + namedVal));
                Pattern classnameEqual = Pattern.compile("([\\w\\p{Sc}\\.]+)\\s*\\=");
                int prevEnd = -1;
                String prevClassName = null;
                Matcher classMatcher = classnameEqual.matcher(namedVal);
                while (classMatcher.find()) {
                    if (prevClassName != null) {
                        found += PluginManager.installNamedConfigs(iname, prevClassName, namedVal.substring(prevEnd, classMatcher.start()).trim().split("\\s*,\\s*"));
                    }
                    prevClassName = classMatcher.group(1);
                    prevEnd = classMatcher.end();
                }
                if (prevClassName != null) {
                    found += PluginManager.installNamedConfigs(iname, prevClassName, namedVal.substring(prevEnd).trim().split("\\s*,\\s*"));
                }
            }
            if ((selfNamedVal = ConfigurationManager.getProperty(SELFNAMED_PREFIX + iname)) != null) {
                String[] classnames = selfNamedVal.trim().split("\\s*,\\s*");
                for (int i = 0; i < classnames.length; ++i) {
                    try {
                        Class<?> pluginClass = Class.forName(classnames[i]);
                        String[] names = (String[])pluginClass.getMethod("getPluginNames", new Class[0]).invoke(null, new Object[0]);
                        if (names == null || names.length == 0) {
                            log.error((Object)("Self-named plugin class \"" + classnames[i] + "\" returned null or empty name list!"));
                            continue;
                        }
                        found += PluginManager.installNamedConfigs(iname, classnames[i], names);
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        log.error((Object)("Implementation Class \"" + classnames[i] + "\" is not a subclass of SelfNamedPlugin, it has no getPluginNames() method."));
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("While configuring self-named plugin: " + e.toString()));
                    }
                }
            }
            namedPluginClasses.put(iname, "org.dspace.core.marker");
            if (found == 0) {
                log.error((Object)("No named plugins found for interface=" + iname));
            }
        }
    }

    private static int installNamedConfigs(String iname, String classname, String[] names) throws ClassNotFoundException {
        int found = 0;
        for (int i = 0; i < names.length; ++i) {
            String key = iname + SEP + names[i];
            if (namedPluginClasses.containsKey(key)) {
                log.error((Object)("Name collision in named plugin, implementation class=\"" + classname + "\", name=\"" + names[i] + "\""));
            } else {
                namedPluginClasses.put(key, classname);
            }
            log.debug((Object)("Got Named Plugin, intfc=" + iname + ", name=" + names[i] + ", class=" + classname));
            ++found;
        }
        return found;
    }

    public static Object getNamedPlugin(Class intfc, String name) throws PluginInstantiationException {
        try {
            String iname = intfc.getName();
            PluginManager.configureNamedPlugin(iname);
            String key = iname + SEP + name;
            String cname = (String)namedPluginClasses.get(key);
            if (cname != null) {
                Class<?> pluginClass = Class.forName(cname);
                if (PluginManager.cacheMe(pluginClass)) {
                    String nkey = pluginClass.getName() + SEP + name;
                    Object cached = namedInstanceCache.get(nkey);
                    if (cached == null) {
                        log.debug((Object)("Creating cached instance of: " + cname + " for interface=" + iname + " pluginName=" + name));
                        cached = pluginClass.newInstance();
                        if (cached instanceof SelfNamedPlugin) {
                            ((SelfNamedPlugin)cached).setPluginInstanceName(name);
                        }
                        namedInstanceCache.put(nkey, cached);
                    }
                    return cached;
                }
                log.debug((Object)("Creating UNcached instance of: " + cname + " for interface=" + iname + " pluginName=" + name));
                Object result = pluginClass.newInstance();
                if (result instanceof SelfNamedPlugin) {
                    ((SelfNamedPlugin)result).setPluginInstanceName(name);
                }
                return result;
            }
            log.warn((Object)("Cannot find named plugin for interface=" + iname + ", name=\"" + name + "\""));
        }
        catch (ClassNotFoundException e) {
            throw new PluginInstantiationException("Cannot load plugin class: " + e.toString(), e);
        }
        catch (InstantiationException e) {
            throw new PluginInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            throw new PluginInstantiationException(e);
        }
        return null;
    }

    public static String[] getAllPluginNames(Class intfc) {
        try {
            String iname = intfc.getName();
            PluginManager.configureNamedPlugin(iname);
            String prefix = iname + SEP;
            ArrayList<String> result = new ArrayList<String>();
            for (String key : namedPluginClasses.keySet()) {
                if (!key.startsWith(prefix)) continue;
                result.add(key.substring(prefix.length()));
            }
            if (result.size() == 0) {
                log.error((Object)("Cannot find any names for named plugin, interface=" + iname));
            }
            return result.toArray(new String[result.size()]);
        }
        catch (ClassNotFoundException e) {
            return new String[0];
        }
    }

    public static void releasePlugin(Object plugin) {
        PluginManager.forgetInstance(plugin, namedInstanceCache);
        PluginManager.forgetInstance(plugin, anonymousInstanceCache);
    }

    private static void forgetInstance(Object plugin, Map cacheMap) {
        Collection values = cacheMap.values();
        for (Object val : values) {
            if (val != plugin) continue;
            values.remove(val);
        }
    }

    private static boolean checkClassname(String iname, String msg) {
        try {
            Class<?> intf = Class.forName(iname);
            return true;
        }
        catch (ClassNotFoundException ce) {
            log.error((Object)("No class definition found for " + msg + ": \"" + iname + "\""));
            return false;
        }
    }

    private static boolean checkSelfNamed(String iname) {
        try {
            if (!PluginManager.checkSelfNamed(Class.forName(iname))) {
                log.error((Object)("The class \"" + iname + "\" is NOT a subclass of SelfNamedPlugin but it should be!"));
            }
        }
        catch (ClassNotFoundException ce) {
            log.error((Object)("No class definition found for self-named class interface: \"" + iname + "\""));
        }
        return false;
    }

    private static boolean checkSelfNamed(Class cls) {
        Class sup = cls.getSuperclass();
        if (sup == null) {
            return false;
        }
        if (sup.equals(SelfNamedPlugin.class)) {
            return true;
        }
        return PluginManager.checkSelfNamed(sup);
    }

    private static void checkNames(String iname) {
        try {
            PluginManager.configureNamedPlugin(iname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void checkConfiguration() throws IOException {
        int i;
        String[] classname;
        String val;
        HashMap<String, String> singleKey = new HashMap<String, String>();
        HashMap<String, String> sequenceKey = new HashMap<String, String>();
        HashMap<String, String> namedKey = new HashMap<String, String>();
        HashMap<String, String> selfnamedKey = new HashMap<String, String>();
        HashMap<String, String> reusableKey = new HashMap<String, String>();
        File config = ConfigurationManager.getConfigurationFile();
        BufferedReader cr = new BufferedReader(new FileReader(config));
        String line = null;
        boolean continued = false;
        HashMap<String, String> keyMap = new HashMap<String, String>();
        Pattern keyPattern = Pattern.compile("([^\\s\\=\\:]+)");
        while ((line = cr.readLine()) != null) {
            Matcher km;
            if ((line = line.trim()).startsWith("!") || line.startsWith("#")) {
                continued = false;
                continue;
            }
            if (!continued && line.startsWith("plugin.") && (km = keyPattern.matcher(line)).find()) {
                String key = line.substring(0, km.end(1));
                if (keyMap.containsKey(key)) {
                    log.error((Object)("Duplicate key \"" + key + "\" in DSpace configuration file=" + config.toString()));
                } else {
                    keyMap.put(key, key);
                }
                if (key.startsWith(SINGLE_PREFIX)) {
                    singleKey.put(key.substring(SINGLE_PREFIX.length()), key);
                } else if (key.startsWith(SEQUENCE_PREFIX)) {
                    sequenceKey.put(key.substring(SEQUENCE_PREFIX.length()), key);
                } else if (key.startsWith(NAMED_PREFIX)) {
                    namedKey.put(key.substring(NAMED_PREFIX.length()), key);
                } else if (key.startsWith(SELFNAMED_PREFIX)) {
                    selfnamedKey.put(key.substring(SELFNAMED_PREFIX.length()), key);
                } else if (key.startsWith(REUSABLE_PREFIX)) {
                    reusableKey.put(key.substring(REUSABLE_PREFIX.length()), key);
                } else {
                    log.error((Object)("Key with unknown prefix \"" + key + "\" in DSpace configuration file=" + config.toString()));
                }
            }
            continued = line.length() > 0 && line.charAt(line.length() - 1) == '\\';
        }
        Enumeration pne = ConfigurationManager.propertyNames();
        HashSet<String> pn = new HashSet<String>();
        while (pne.hasMoreElements()) {
            String nk = (String)pne.nextElement();
            if (!nk.startsWith("plugin.")) continue;
            pn.add(nk);
            if (keyMap.containsKey(nk)) continue;
            log.error((Object)("Key is in ConfigurationManager.propertyNames() but NOT text crawl: \"" + nk + "\""));
        }
        for (String key : keyMap.keySet()) {
            if (pn.contains(key)) continue;
            log.error((Object)("Key is in text crawl but NOT ConfigurationManager.propertyNames(): \"" + key + "\""));
        }
        ArrayList allInterfaces = new ArrayList();
        allInterfaces.addAll(singleKey.keySet());
        allInterfaces.addAll(sequenceKey.keySet());
        allInterfaces.addAll(namedKey.keySet());
        allInterfaces.addAll(selfnamedKey.keySet());
        allInterfaces.addAll(reusableKey.keySet());
        Iterator<Object> ii = allInterfaces.iterator();
        while (ii.hasNext()) {
            PluginManager.checkClassname((String)ii.next(), "key interface or class");
        }
        HashMap<String, String> allImpls = new HashMap<String, String>();
        for (String key : singleKey.keySet()) {
            val = ConfigurationManager.getProperty(SINGLE_PREFIX + key);
            if (val == null) {
                log.error((Object)("Single plugin config not found for: plugin.single." + key));
                continue;
            }
            if (!PluginManager.checkClassname(val = val.trim(), "implementation class")) continue;
            allImpls.put(val, val);
        }
        for (String key : sequenceKey.keySet()) {
            val = ConfigurationManager.getProperty(SEQUENCE_PREFIX + key);
            if (val == null) {
                log.error((Object)("Sequence plugin config not found for: plugin.sequence." + key));
                continue;
            }
            val = val.trim();
            classname = val.split("\\s*,\\s*");
            for (i = 0; i < classname.length; ++i) {
                if (!PluginManager.checkClassname(classname[i], "implementation class")) continue;
                allImpls.put(classname[i], classname[i]);
            }
        }
        for (String key : selfnamedKey.keySet()) {
            val = ConfigurationManager.getProperty(SELFNAMED_PREFIX + key);
            if (val == null) {
                log.error((Object)("Selfnamed plugin config not found for: plugin.selfnamed." + key));
                continue;
            }
            val = val.trim();
            classname = val.split("\\s*,\\s*");
            for (i = 0; i < classname.length; ++i) {
                if (!PluginManager.checkClassname(classname[i], "selfnamed implementation class")) continue;
                allImpls.put(classname[i], classname[i]);
                PluginManager.checkSelfNamed(classname[i]);
            }
            PluginManager.checkNames(key);
        }
        ii = namedKey.keySet().iterator();
        Pattern classnameEqual = Pattern.compile("([\\w\\p{Sc}\\.]+)\\s*\\=");
        while (ii.hasNext()) {
            String key = (String)ii.next();
            String val2 = ConfigurationManager.getProperty(NAMED_PREFIX + key);
            if (val2 == null) {
                log.error((Object)("Named plugin config not found for: plugin.named." + key));
                continue;
            }
            PluginManager.checkNames(key);
            val2 = val2.trim();
            Matcher classMatcher = classnameEqual.matcher(val2);
            while (classMatcher.find()) {
                String classname2 = classMatcher.group(1);
                if (!PluginManager.checkClassname(classname2, "implementation class")) continue;
                allImpls.put(classname2, classname2);
            }
        }
        for (String rk : reusableKey.keySet()) {
            if (allImpls.containsKey(rk)) continue;
            log.error((Object)("In plugin.reusable configuration, class \"" + rk + "\" is NOT a plugin implementation class."));
        }
    }

    public static void main(String[] argv) throws Exception {
        PluginManager.checkConfiguration();
    }
}

