/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;

public class TableRowIterator {
    private ResultSet results;
    private Statement statemt = null;
    private String table;
    private boolean hasNext = true;
    private boolean hasAdvanced = false;

    TableRowIterator(ResultSet results) {
        this(results, null);
        this.statemt = null;
    }

    TableRowIterator(ResultSet results, String table) {
        this.results = results;
        this.table = table;
        this.statemt = null;
    }

    public void finalize() {
        this.close();
    }

    public void setStatement(Statement st) {
        this.statemt = st;
    }

    public TableRow next() throws SQLException {
        if (this.results == null) {
            return null;
        }
        if (!this.hasNext()) {
            return null;
        }
        this.hasAdvanced = false;
        return DatabaseManager.process(this.results, this.table);
    }

    public boolean hasNext() throws SQLException {
        if (this.results == null) {
            this.close();
            return false;
        }
        if (this.hasAdvanced) {
            return this.hasNext;
        }
        this.hasAdvanced = true;
        this.hasNext = this.results.next();
        if (!this.hasNext) {
            this.close();
        }
        return this.hasNext;
    }

    public List toList() throws SQLException {
        ArrayList<TableRow> resultsList = new ArrayList<TableRow>();
        while (this.hasNext()) {
            resultsList.add(this.next());
        }
        this.close();
        return resultsList;
    }

    public void close() {
        try {
            if (this.results != null) {
                this.results.close();
                this.results = null;
            }
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            if (this.statemt != null) {
                this.statemt.close();
                this.statemt = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

