/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseItem;
import org.dspace.browse.ItemListConfig;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.sort.SortOption;

public class BrowseInfo {
    private List results;
    private int overallPosition;
    private int offset;
    private int total;
    private boolean cached;
    private BrowseIndex browseIndex;
    private SortOption sortOption;
    private boolean ascending;
    private int level = 0;
    private String value;
    private boolean startsWith = false;
    private Collection collection;
    private Community community;
    private int nextItem = -1;
    private String nextValue;
    private int prevItem = -1;
    private String prevValue;
    private String focus;
    private int resultsPerPage = -1;
    private int focusItem = -1;
    private int etAl = -1;

    public BrowseInfo(List results, int overallPosition, int total, int offset) {
        if (results == null) {
            throw new IllegalArgumentException("Null result list not allowed");
        }
        this.results = Collections.unmodifiableList(results);
        this.overallPosition = overallPosition;
        this.total = total;
        this.offset = offset;
    }

    public int getEtAl() {
        return this.etAl;
    }

    public void setEtAl(int etAl) {
        this.etAl = etAl;
    }

    public int getFocusItem() {
        return this.focusItem;
    }

    public void setFocusItem(int focusItem) {
        this.focusItem = focusItem;
    }

    public boolean hasItemFocus() {
        return this.focusItem != -1;
    }

    public int getResultsPerPage() {
        return this.resultsPerPage;
    }

    public void setResultsPerPage(int resultsPerPage) {
        this.resultsPerPage = resultsPerPage;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean hasResults() {
        return this.results.size() > 0;
    }

    public void setFocus(String focus) {
        this.focus = focus;
    }

    public String getFocus() {
        return this.focus;
    }

    public void setBrowseContainer(DSpaceObject dso) throws BrowseException {
        if (dso instanceof Collection) {
            this.collection = (Collection)dso;
        } else if (dso instanceof Community) {
            this.community = (Community)dso;
        } else {
            throw new BrowseException("The container must be a community or a collection");
        }
    }

    public DSpaceObject getBrowseContainer() {
        if (this.collection != null) {
            return this.collection;
        }
        if (this.community != null) {
            return this.community;
        }
        return null;
    }

    public void setBrowseLevel(int level) {
        this.level = level;
    }

    public int getBrowseLevel() {
        return this.level;
    }

    public void setNextItem(int id) {
        this.nextItem = id;
    }

    public int getNextItem() {
        return this.nextItem;
    }

    public void setNextValue(String value) {
        this.nextValue = value;
    }

    public String getNextValue() {
        return this.nextValue;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public BrowseIndex getBrowseIndex() {
        return this.browseIndex;
    }

    public void setBrowseIndex(BrowseIndex browseIndex) {
        this.browseIndex = browseIndex;
    }

    public int getPrevItem() {
        return this.prevItem;
    }

    public void setPrevItem(int prevItem) {
        this.prevItem = prevItem;
    }

    public String getPrevValue() {
        return this.prevValue;
    }

    public void setPrevValue(String prevValue) {
        this.prevValue = prevValue;
    }

    public SortOption getSortOption() {
        return this.sortOption;
    }

    public void setSortOption(SortOption sortOption) {
        this.sortOption = sortOption;
    }

    public boolean isStartsWith() {
        return this.startsWith;
    }

    public void setStartsWith(boolean startsWith) {
        this.startsWith = startsWith;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isTopLevel() {
        return this.level == 0;
    }

    public boolean isSecondLevel() {
        return this.level == 1;
    }

    public List getResults() {
        return this.results;
    }

    public String[] getStringResults() {
        return this.results.toArray(new String[this.results.size()]);
    }

    public Item[] getItemResults() {
        return new Item[0];
    }

    public Item[] getItemResults(Context context) throws BrowseException {
        try {
            BrowseItem[] bis = this.getBrowseItemResults();
            Item[] items = new Item[bis.length];
            for (int i = 0; i < bis.length; ++i) {
                items[i] = Item.find(context, bis[i].getID());
            }
            return items;
        }
        catch (SQLException e) {
            throw new BrowseException(e);
        }
    }

    public BrowseItem[] getBrowseItemResults() {
        return this.results.toArray(new BrowseItem[this.results.size()]);
    }

    public int getResultCount() {
        return this.results.size();
    }

    public int getOverallPosition() {
        return this.overallPosition;
    }

    public int getTotal() {
        return this.total;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isFirst() {
        return this.overallPosition == 0;
    }

    public boolean isLast() {
        return this.overallPosition + this.getResultCount() == this.total;
    }

    public boolean wasCached() {
        return this.cached;
    }

    void setCached(boolean cached) {
        this.cached = cached;
    }

    public boolean inCommunity() {
        return this.community != null;
    }

    public boolean inCollection() {
        return this.collection != null;
    }

    public boolean hasNextPage() {
        if (!"".equals(this.nextValue) && this.nextValue != null) {
            return true;
        }
        return this.nextItem != -1;
    }

    public boolean hasPrevPage() {
        if (!"".equals(this.prevValue) && this.prevValue != null) {
            return true;
        }
        return this.prevItem != -1;
    }

    public boolean hasFocus() {
        return !"".equals(this.focus) && this.focus != null;
    }

    public int getStart() {
        return this.overallPosition + 1;
    }

    public int getFinish() {
        return this.overallPosition + this.results.size();
    }

    public String toString() {
        try {
            StringBuffer sb = new StringBuffer();
            String from = Integer.toString(this.overallPosition + 1);
            String to = Integer.toString(this.overallPosition + this.results.size());
            String of = Integer.toString(this.total);
            sb.append("BrowseInfo String Representation: ");
            sb.append("Browsing " + from + " to " + to + " of " + of + " ");
            sb.append("in index: " + this.browseIndex.getName() + " (data type: " + this.browseIndex.getDataType() + ", display type: " + this.browseIndex.getDisplayType() + ") ");
            sb.append("||");
            String container = "all of DSpace";
            DSpaceObject theContainer = null;
            if (this.inCollection()) {
                container = "collection";
                theContainer = this.collection;
            } else if (this.inCommunity()) {
                container = "community";
                theContainer = this.community;
            }
            String containerID = "no id available/necessary";
            if (theContainer != null) {
                containerID = Integer.toString(theContainer.getID()) + " (" + theContainer.getHandle() + ")";
            }
            sb.append("Browsing in " + container + ": " + containerID);
            sb.append("||");
            ItemListConfig config = new ItemListConfig();
            if (this.browseIndex.isItemIndex()) {
                sb.append("Listing over " + Integer.toString(config.numCols()) + " columns: ");
                for (int k = 1; k <= config.numCols(); ++k) {
                    if (k > 1) {
                        sb.append(",");
                    }
                    String[] meta = config.getMetadata(k);
                    sb.append(meta[0] + "." + meta[1] + "." + meta[2]);
                }
                if (this.value != null) {
                    sb.append(" on value: " + this.value);
                }
                if (this.isStartsWith()) {
                    sb.append(" sort column starting with: " + this.focus);
                } else if (this.hasFocus()) {
                    sb.append(" sort column focus: " + this.focus);
                }
            } else if (this.browseIndex.isMetadataIndex()) {
                sb.append("Listing single column: " + this.browseIndex.getMetadata());
                if (this.isStartsWith()) {
                    sb.append(" sort column starting with: " + this.focus);
                } else if (this.hasFocus()) {
                    sb.append(" sort column focus: " + this.focus);
                }
            }
            sb.append("||");
            String direction = this.ascending ? "ASC" : "DESC";
            sb.append("Sorting by: " + this.sortOption.getMetadata() + " " + direction + " (option " + Integer.toString(this.sortOption.getNumber()) + ")");
            sb.append("||");
            if (this.browseIndex.isMetadataIndex() && !this.isSecondLevel()) {
                sb.append(this.valueListingString());
            } else if (this.browseIndex.isItemIndex() || this.isSecondLevel()) {
                sb.append(this.fullListingString(config));
            }
            sb.append("||");
            sb.append("Top of next page: ");
            if (this.hasNextPage()) {
                if (this.browseIndex.isMetadataIndex() && !this.isSecondLevel()) {
                    sb.append(this.nextValue);
                } else if (this.browseIndex.isItemIndex() || this.isSecondLevel()) {
                    sb.append("Item ID: " + Integer.toString(this.nextItem));
                }
            } else {
                sb.append("n/a");
            }
            sb.append(";");
            sb.append("Top of previous page: ");
            if (this.hasPrevPage()) {
                if (this.browseIndex.isMetadataIndex() && !this.isSecondLevel()) {
                    sb.append(this.prevValue);
                } else if (this.browseIndex.isItemIndex() || this.isSecondLevel()) {
                    sb.append("Item ID: " + Integer.toString(this.prevItem));
                }
            } else {
                sb.append("n/a");
            }
            sb.append("||");
            return sb.toString();
        }
        catch (SQLException e) {
            return e.getMessage();
        }
        catch (BrowseException e) {
            return e.getMessage();
        }
    }

    private String fullListingString(ItemListConfig config) throws SQLException {
        StringBuffer sb = new StringBuffer();
        for (BrowseItem bi : this.results) {
            if (bi == null) {
                sb.append("{{ NULL ITEM }}");
                break;
            }
            sb.append("{{Item ID: " + Integer.toString(bi.getID()) + " :: ");
            for (int j = 1; j <= config.numCols(); ++j) {
                String[] md = config.getMetadata(j);
                if (md == null) {
                    sb.append("{{ NULL METADATA }}");
                    break;
                }
                DCValue[] values = bi.getMetadata(md[0], md[1], md[2], "*");
                StringBuffer value = new StringBuffer();
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        if (i > 0) {
                            value.append(",");
                        }
                        value.append(values[i].value);
                    }
                } else {
                    value.append("-");
                }
                String metadata = "[" + md[0] + "." + md[1] + "." + md[2] + ":" + value.toString() + "]";
                sb.append(metadata);
            }
            sb.append("}}");
        }
        return sb.toString();
    }

    private String valueListingString() {
        StringBuffer sb = new StringBuffer();
        for (String theValue : this.results) {
            if (theValue == null) {
                sb.append("{{ NULL VALUE }}");
                break;
            }
            sb.append("{{Value: " + theValue + "}}");
        }
        return sb.toString();
    }
}

