/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.submit.AbstractProcessingStep;

public class UploadStep
extends AbstractProcessingStep {
    public static final String SUBMIT_UPLOAD_BUTTON = "submit_upload";
    public static final String SUBMIT_SKIP_BUTTON = "submit_skip";
    public static final String SUBMIT_MORE_BUTTON = "submit_more";
    public static final String CANCEL_EDIT_BUTTON = "submit_edit_cancel";
    public static final int STATUS_INTEGRITY_ERROR = 1;
    public static final int STATUS_UPLOAD_ERROR = 2;
    public static final int STATUS_NO_FILES_ERROR = 5;
    public static final int STATUS_UNKNOWN_FORMAT = 10;
    public static final int STATUS_EDIT_BITSTREAM = 20;
    public static final int STATUS_EDIT_COMPLETE = 25;
    private static Logger log = Logger.getLogger(UploadStep.class);

    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        boolean fileRequired;
        int status;
        int status2;
        int status3;
        String buttonPressed = Util.getSubmitButton(request, NEXT_BUTTON);
        Item item = subInfo.getSubmissionItem().getItem();
        if (buttonPressed.startsWith(PROGRESS_BAR_PREFIX)) {
            return STATUS_COMPLETE;
        }
        if (request.getParameter("bitstream_id") != null) {
            if (buttonPressed.equals(CANCEL_EDIT_BUTTON)) {
                subInfo.setBitstream(null);
                return 25;
            }
            Bitstream b = Bitstream.find(context, Integer.parseInt(request.getParameter("bitstream_id")));
            subInfo.setBitstream(b);
        } else if (buttonPressed.startsWith("submit_edit_")) {
            String bitstreamID = buttonPressed.substring("submit_edit_".length());
            Bitstream b = Bitstream.find(context, Integer.parseInt(bitstreamID));
            subInfo.setBitstream(b);
            return 20;
        }
        if (buttonPressed.equalsIgnoreCase("submit_remove_selected")) {
            if (request.getParameter("remove") != null) {
                String[] removeIDs = request.getParameterValues("remove");
                for (int i = 0; i < removeIDs.length; ++i) {
                    int id = Integer.parseInt(removeIDs[i]);
                    int status4 = this.processRemoveFile(context, item, id);
                    if (status4 == STATUS_COMPLETE) continue;
                    return status4;
                }
                subInfo.setBitstream(null);
            }
        } else if (buttonPressed.startsWith("submit_remove_")) {
            int id = Integer.parseInt(buttonPressed.substring(14));
            status3 = this.processRemoveFile(context, item, id);
            if (status3 != STATUS_COMPLETE) {
                return status3;
            }
            subInfo.setBitstream(null);
        }
        String contentType = request.getContentType();
        if (buttonPressed.equalsIgnoreCase(SUBMIT_UPLOAD_BUTTON) && contentType != null && contentType.indexOf("multipart/form-data") != -1 && (status3 = this.processUploadFile(context, request, response, subInfo)) != STATUS_COMPLETE) {
            return status3;
        }
        String fileDescription = request.getParameter("description");
        if (fileDescription != null && fileDescription.length() > 0 && (status2 = this.processSaveFileDescription(context, request, response, subInfo)) != STATUS_COMPLETE) {
            return status2;
        }
        int formatTypeID = Util.getIntParameter(request, "format");
        String formatDesc = request.getParameter("format_description");
        if ((formatTypeID >= 0 || formatDesc != null && formatDesc.length() > 0) && (status = this.processSaveFileFormat(context, request, response, subInfo)) != STATUS_COMPLETE) {
            return status;
        }
        if (request.getParameter("primary_bitstream_id") != null) {
            Bundle[] bundles = item.getBundles("ORIGINAL");
            bundles[0].setPrimaryBitstreamID(new Integer(request.getParameter("primary_bitstream_id")));
            bundles[0].update();
        }
        if (fileRequired = ConfigurationManager.getBooleanProperty("webui.submit.upload.required", true)) {
            Bundle[] bundles = item.getBundles("ORIGINAL");
            if (bundles.length == 0) {
                return 5;
            }
            Bitstream[] bitstreams = bundles[0].getBitstreams();
            if (bitstreams.length == 0) {
                return 5;
            }
        }
        context.commit();
        return STATUS_COMPLETE;
    }

    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        return 1;
    }

    protected int processRemoveFile(Context context, Item item, int bitstreamID) throws IOException, SQLException, AuthorizeException {
        Bitstream bitstream;
        try {
            bitstream = Bitstream.find(context, bitstreamID);
        }
        catch (NumberFormatException nfe) {
            bitstream = null;
        }
        if (bitstream == null) {
            return 1;
        }
        Bundle[] bundles = bitstream.getBundles();
        bundles[0].removeBitstream(bitstream);
        Bitstream[] bitstreams = bundles[0].getBitstreams();
        if (bitstreams.length < 1) {
            item.removeBundle(bundles[0]);
            item.update();
        }
        return STATUS_COMPLETE;
    }

    protected int processUploadFile(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        boolean formatKnown = true;
        boolean fileOK = false;
        BitstreamFormat bf = null;
        Bitstream b = null;
        Enumeration attNames = request.getAttributeNames();
        while (attNames.hasMoreElements()) {
            String attr = (String)attNames.nextElement();
            if (!attr.endsWith("-path")) continue;
            String param = attr.replace("-path", "");
            String filePath = (String)request.getAttribute(param + "-path");
            InputStream fileInputStream = (InputStream)request.getAttribute(param + "-inputstream");
            String fileDescription = (String)request.getAttribute(param + "-description");
            if (fileDescription == null || fileDescription.length() == 0) {
                request.getParameter("description");
            }
            if (filePath == null || fileInputStream == null) {
                return 2;
            }
            if (subInfo != null) {
                Item item = subInfo.getSubmissionItem().getItem();
                Bundle[] bundles = item.getBundles("ORIGINAL");
                b = bundles.length < 1 ? item.createSingleBitstream(fileInputStream, "ORIGINAL") : bundles[0].createBitstream(fileInputStream);
                String noPath = filePath;
                while (noPath.indexOf(47) > -1) {
                    noPath = noPath.substring(noPath.indexOf(47) + 1);
                }
                while (noPath.indexOf(92) > -1) {
                    noPath = noPath.substring(noPath.indexOf(92) + 1);
                }
                b.setName(noPath);
                b.setSource(filePath);
                b.setDescription(fileDescription);
                bf = FormatIdentifier.guessFormat(context, b);
                b.setFormat(bf);
                b.update();
                item.update();
                if (bf == null || !bf.isInternal()) {
                    fileOK = true;
                } else {
                    log.warn((Object)"Attempt to upload file format marked as internal system use only");
                }
            } else {
                return 1;
            }
            if (fileOK) {
                context.commit();
                subInfo.setBitstream(b);
                if (bf != null) continue;
                formatKnown = false;
                continue;
            }
            return 2;
        }
        if (!formatKnown) {
            return 10;
        }
        return STATUS_COMPLETE;
    }

    protected int processSaveFileFormat(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        if (subInfo.getBitstream() != null) {
            int typeID = Util.getIntParameter(request, "format");
            BitstreamFormat format = BitstreamFormat.find(context, typeID);
            if (format != null) {
                subInfo.getBitstream().setFormat(format);
            } else {
                String userDesc = request.getParameter("format_description");
                subInfo.getBitstream().setUserFormatDescription(userDesc);
            }
        } else {
            return 1;
        }
        subInfo.getBitstream().update();
        return STATUS_COMPLETE;
    }

    protected int processSaveFileDescription(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        if (subInfo.getBitstream() == null) {
            return 1;
        }
        subInfo.getBitstream().setDescription(request.getParameter("description"));
        subInfo.getBitstream().update();
        context.commit();
        return STATUS_COMPLETE;
    }
}

