/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.packager.AbstractMETSIngester;
import org.dspace.content.packager.METSManifest;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.Context;
import org.dspace.license.CreativeCommons;
import org.jdom.Element;

public class DSpaceMETSIngester
extends AbstractMETSIngester {
    private static Logger log = Logger.getLogger(DSpaceMETSIngester.class);
    private static final String PROFILE_START = "DSpace METS SIP Profile";

    void checkManifest(METSManifest manifest) throws MetadataValidationException {
        String profile = manifest.getProfile();
        if (profile == null) {
            throw new MetadataValidationException("Cannot accept METS with no PROFILE attribute!");
        }
        if (!profile.startsWith(PROFILE_START)) {
            throw new MetadataValidationException("METS has unacceptable PROFILE value, profile=" + profile);
        }
    }

    public void checkPackageFiles(Set packageFiles, Set missingFiles, METSManifest manifest) throws PackageValidationException, CrosswalkException {
    }

    public void chooseItemDmd(Context context, Item item, METSManifest manifest, AbstractMETSIngester.MdrefManager callback, Element[] dmds) throws CrosswalkException, AuthorizeException, SQLException, IOException {
        int i;
        int found = -1;
        for (i = 0; i < dmds.length; ++i) {
            if (!"MODS".equals(manifest.getMdType(dmds[i]))) continue;
            found = i;
        }
        if (found == -1) {
            for (i = 0; i < dmds.length; ++i) {
                if (!"DC".equals(manifest.getMdType(dmds[i]))) continue;
                found = i;
            }
        }
        String groupID = null;
        if (found >= 0) {
            manifest.crosswalkItem(context, item, dmds[found], callback);
            groupID = dmds[found].getAttributeValue("GROUPID");
            if (groupID != null) {
                for (int i2 = 0; i2 < dmds.length; ++i2) {
                    String g = dmds[i2].getAttributeValue("GROUPID");
                    if (g == null || g.equals(groupID)) continue;
                    manifest.crosswalkItem(context, item, dmds[i2], callback);
                }
            }
        } else if (dmds.length > 0) {
            manifest.crosswalkItem(context, item, dmds[0], callback);
        }
    }

    public void addLicense(Context context, Collection collection, Item item, METSManifest manifest, AbstractMETSIngester.MdrefManager callback, String license) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        PackageUtils.addDepositLicense(context, license, item, collection);
        Element[] rmds = manifest.getItemRightsMD();
        for (int i = 0; i < rmds.length; ++i) {
            Bundle[] parent;
            Bitstream bs;
            String type = manifest.getMdType(rmds[i]);
            if (type == null || !type.equals("Creative Commons")) continue;
            log.debug((Object)"Got Creative Commons license in rightsMD");
            CreativeCommons.setLicense(context, item, manifest.getMdContentAsStream(rmds[i], callback), manifest.getMdContentMimeType(rmds[i]));
            Element mdRef = rmds[i].getChild("mdRef", METSManifest.metsNS);
            if (mdRef == null || (bs = callback.getBitstreamForMdRef(mdRef)) == null || (parent = bs.getBundles()).length <= 0) continue;
            parent[0].removeBitstream(bs);
            parent[0].update();
        }
    }

    public void finishItem(Context context, Item item) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
    }
}

