/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sort;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.core.PluginManager;
import org.dspace.sort.OrderFormatAuthor;
import org.dspace.sort.OrderFormatDelegate;
import org.dspace.sort.OrderFormatText;
import org.dspace.sort.OrderFormatTitle;

public class OrderFormat {
    private static final Logger log = LogManager.getLogger(OrderFormat.class);
    public static final String AUTHOR = "author";
    public static final String TITLE = "title";
    public static final String TEXT = "text";
    private static final String[] delegates = PluginManager.getAllPluginNames(OrderFormatDelegate.class);
    private static final OrderFormatDelegate authorDelegate = new OrderFormatAuthor();
    private static final OrderFormatDelegate titleDelegate = new OrderFormatTitle();
    private static final OrderFormatDelegate textDelegate = new OrderFormatText();

    public static String makeSortString(String value, String language, String type) {
        OrderFormatDelegate delegate = null;
        if (value == null) {
            return null;
        }
        if (type != null && type.length() > 0 && (delegate = OrderFormat.getDelegate(type)) != null) {
            return delegate.makeSortString(value, language);
        }
        if (type.equalsIgnoreCase(AUTHOR) && authorDelegate != null) {
            return authorDelegate.makeSortString(value, language);
        }
        if (type.equalsIgnoreCase(TITLE) && titleDelegate != null) {
            return titleDelegate.makeSortString(value, language);
        }
        if (type.equalsIgnoreCase(TEXT) && textDelegate != null) {
            return textDelegate.makeSortString(value, language);
        }
        return value;
    }

    private static OrderFormatDelegate getDelegate(String name) {
        if (name != null && name.length() > 0) {
            for (int idx = 0; idx < delegates.length; ++idx) {
                if (!delegates[idx].equals(name)) continue;
                return (OrderFormatDelegate)PluginManager.getNamedPlugin(OrderFormatDelegate.class, name);
            }
        }
        return null;
    }
}

