/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemexport;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.eperson.EPerson;
import org.dspace.handle.HandleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemExport {
    private static final int SUBDIR_LIMIT = 0;
    public static final String COMPRESSED_EXPORT_MIME_TYPE = "application/zip";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("t", "type", true, "type: COLLECTION or ITEM");
        options.addOption("i", "id", true, "ID or handle of thing to export");
        options.addOption("d", "dest", true, "destination where you want items to go");
        options.addOption("n", "number", true, "sequence number to begin exporting items with");
        options.addOption("h", "help", false, "help");
        CommandLine line = parser.parse(options, argv);
        String typeString = null;
        String destDirName = null;
        String myIDString = null;
        int seqStart = -1;
        int myType = -1;
        Item myItem = null;
        Collection mycollection = null;
        if (line.hasOption('h')) {
            HelpFormatter myhelp = new HelpFormatter();
            myhelp.printHelp("ItemExport\n", options);
            System.out.println("\nfull collection: ItemExport -t COLLECTION -i ID -d dest -n number");
            System.out.println("singleitem:       ItemExport -t ITEM -i ID -d dest -n number");
            System.exit(0);
        }
        if (line.hasOption('t')) {
            typeString = line.getOptionValue('t');
            if (typeString.equals("ITEM")) {
                myType = 2;
            } else if (typeString.equals("COLLECTION")) {
                myType = 3;
            }
        }
        if (line.hasOption('i')) {
            myIDString = line.getOptionValue('i');
        }
        if (line.hasOption('d')) {
            destDirName = line.getOptionValue('d');
        }
        if (line.hasOption('n')) {
            seqStart = Integer.parseInt(line.getOptionValue('n'));
        }
        if (myType == -1) {
            System.out.println("type must be either COLLECTION or ITEM (-h for help)");
            System.exit(1);
        }
        if (destDirName == null) {
            System.out.println("destination directory must be set (-h for help)");
            System.exit(1);
        }
        if (seqStart == -1) {
            System.out.println("sequence start number must be set (-h for help)");
            System.exit(1);
        }
        if (myIDString == null) {
            System.out.println("ID must be set to either a database ID or a handle (-h for help)");
            System.exit(1);
        }
        Context c = new Context();
        c.setIgnoreAuthorization(true);
        if (myType == 2) {
            if (myIDString.indexOf(47) != -1) {
                myItem = (Item)HandleManager.resolveToObject(c, myIDString);
                if (myItem == null || myItem.getType() != 2) {
                    myItem = null;
                }
            } else {
                myItem = Item.find(c, Integer.parseInt(myIDString));
            }
            if (myItem == null) {
                System.out.println("Error, item cannot be found: " + myIDString);
            }
        } else {
            if (myIDString.indexOf(47) != -1) {
                mycollection = (Collection)HandleManager.resolveToObject(c, myIDString);
                if (mycollection == null || mycollection.getType() != 3) {
                    mycollection = null;
                }
            } else if (myIDString != null) {
                mycollection = Collection.find(c, Integer.parseInt(myIDString));
            }
            if (mycollection == null) {
                System.out.println("Error, collection cannot be found: " + myIDString);
                System.exit(1);
            }
        }
        if (myItem != null) {
            ItemExport.exportItem(c, myItem, destDirName, seqStart);
        } else {
            System.out.println("Exporting from collection: " + myIDString);
            ItemIterator i = mycollection.getItems();
            try {
                ItemExport.exportItem(c, i, destDirName, seqStart);
            }
            finally {
                if (i != null) {
                    i.close();
                }
            }
        }
        c.complete();
    }

    private static void exportItem(Context c, ItemIterator i, String destDirName, int seqStart) throws Exception {
        int mySequenceNumber = seqStart;
        int counter = -1;
        boolean subDirSuffix = false;
        String fullPath = destDirName;
        String subdir = "";
        System.out.println("Beginning export");
        while (i.hasNext()) {
            System.out.println("Exporting item to " + mySequenceNumber);
            ItemExport.exportItem(c, i.next(), fullPath, mySequenceNumber);
            ++mySequenceNumber;
        }
    }

    private static void exportItem(Context c, Item myItem, String destDirName, int seqStart) throws Exception {
        File itemDir;
        File destDir = new File(destDirName);
        if (destDir.exists()) {
            itemDir = new File(destDir + "/" + seqStart);
            System.out.println("Exporting Item " + myItem.getID() + " to " + itemDir);
            if (itemDir.exists()) {
                throw new Exception("Directory " + destDir + "/" + seqStart + " already exists!");
            }
            if (!itemDir.mkdir()) {
                throw new Exception("Error, can't make dir " + itemDir);
            }
        } else {
            throw new Exception("Error, directory " + destDirName + " doesn't exist!");
        }
        ItemExport.writeMetadata(c, myItem, itemDir);
        ItemExport.writeBitstreams(c, myItem, itemDir);
        ItemExport.writeHandle(c, myItem, itemDir);
    }

    private static void writeMetadata(Context c, Item i, File destDir) throws Exception {
        HashMap map = new HashMap();
        DCValue[] dcorevalues = i.getMetadata("*", "*", "*", "*");
        for (int ii = 0; ii < dcorevalues.length; ++ii) {
            map.put(dcorevalues[ii].schema, null);
        }
        for (String schema : map.keySet()) {
            ItemExport.writeMetadata(c, schema, i, destDir);
        }
    }

    private static void writeMetadata(Context c, String schema, Item i, File destDir) throws Exception {
        byte[] utf8;
        BufferedOutputStream out;
        String filename = schema.equals("dc") ? "dublin_core.xml" : "metadata_" + schema + ".xml";
        File outFile = new File(destDir, filename);
        System.out.println("Attempting to create file " + outFile);
        if (outFile.createNewFile()) {
            out = new BufferedOutputStream(new FileOutputStream(outFile));
            DCValue[] dcorevalues = i.getMetadata(schema, "*", "*", "*");
            utf8 = "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n".getBytes("UTF-8");
            out.write(utf8, 0, utf8.length);
            String dcTag = "<dublin_core schema=\"" + schema + "\">\n";
            utf8 = dcTag.getBytes("UTF-8");
            out.write(utf8, 0, utf8.length);
            for (int j = 0; j < dcorevalues.length; ++j) {
                DCValue dcv = dcorevalues[j];
                String qualifier = dcv.qualifier;
                if (qualifier == null) {
                    qualifier = "none";
                }
                utf8 = ("  <dcvalue element=\"" + dcv.element + "\" " + "qualifier=\"" + qualifier + "\">" + Utils.addEntities(dcv.value) + "</dcvalue>\n").getBytes("UTF-8");
                out.write(utf8, 0, utf8.length);
            }
        } else {
            throw new Exception("Cannot create dublin_core.xml in " + destDir);
        }
        utf8 = "</dublin_core>\n".getBytes("UTF-8");
        out.write(utf8, 0, utf8.length);
        out.close();
    }

    private static void writeHandle(Context c, Item i, File destDir) throws Exception {
        if (i.getHandle() == null) {
            return;
        }
        String filename = "handle";
        File outFile = new File(destDir, filename);
        if (!outFile.createNewFile()) {
            throw new Exception("Cannot create file " + filename + " in " + destDir);
        }
        PrintWriter out = new PrintWriter(new FileWriter(outFile));
        out.println(i.getHandle());
        out.close();
    }

    private static void writeBitstreams(Context c, Item i, File destDir) throws Exception {
        PrintWriter out;
        File outFile = new File(destDir, "contents");
        if (outFile.createNewFile()) {
            out = new PrintWriter(new FileWriter(outFile));
            Bundle[] bundles = i.getBundles();
            for (int j = 0; j < bundles.length; ++j) {
                Bitstream[] bitstreams = bundles[j].getBitstreams();
                String bundleName = bundles[j].getName();
                for (int k = 0; k < bitstreams.length; ++k) {
                    String myName;
                    Bitstream b = bitstreams[k];
                    String oldName = myName = b.getName();
                    int myPrefix = 1;
                    InputStream is = b.retrieve();
                    boolean isDone = false;
                    while (!isDone) {
                        File fout = new File(destDir, myName);
                        if (fout.createNewFile()) {
                            FileOutputStream fos = new FileOutputStream(fout);
                            Utils.bufferedCopy(is, fos);
                            is.close();
                            fos.close();
                            if (b.isRegisteredBitstream()) {
                                out.println("-r -s " + b.getStoreNumber() + " -f " + myName + "\tbundle:" + bundleName);
                            } else {
                                out.println(myName + "\tbundle:" + bundleName);
                            }
                            isDone = true;
                            continue;
                        }
                        myName = myPrefix + "_" + oldName;
                        ++myPrefix;
                    }
                }
            }
        } else {
            throw new Exception("Cannot create contents in " + destDir);
        }
        out.close();
    }

    public static void createDownloadableExport(DSpaceObject dso, Context context) throws Exception {
        EPerson eperson = context.getCurrentUser();
        ArrayList<DSpaceObject> list = new ArrayList<DSpaceObject>(1);
        list.add(dso);
        ItemExport.processDownloadableExport(list, context, eperson == null ? null : eperson.getEmail());
    }

    public static void createDownloadableExport(List<DSpaceObject> dsObjects, Context context) throws Exception {
        EPerson eperson = context.getCurrentUser();
        ItemExport.processDownloadableExport(dsObjects, context, eperson == null ? null : eperson.getEmail());
    }

    public static void createDownloadableExport(DSpaceObject dso, Context context, String additionalEmail) throws Exception {
        ArrayList<DSpaceObject> list = new ArrayList<DSpaceObject>(1);
        list.add(dso);
        ItemExport.processDownloadableExport(list, context, additionalEmail);
    }

    public static void createDownloadableExport(List<DSpaceObject> dsObjects, Context context, String additionalEmail) throws Exception {
        ItemExport.processDownloadableExport(dsObjects, context, additionalEmail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processDownloadableExport(List<DSpaceObject> dsObjects, Context context, final String additionalEmail) throws Exception {
        final EPerson eperson = context.getCurrentUser();
        ItemExport.deleteOldExportArchives(eperson.getID());
        float size = 0.0f;
        final ArrayList<Integer> items = new ArrayList<Integer>();
        for (DSpaceObject dso : dsObjects) {
            if (dso.getType() == 4) {
                Community community = (Community)dso;
                Collection[] collections = community.getCollections();
                for (DSpaceObject dSpaceObject : collections) {
                    ItemIterator iitems = ((Collection)dSpaceObject).getItems();
                    try {
                        while (iitems.hasNext()) {
                            Bundle[] bundles;
                            Item item = iitems.next();
                            for (Bundle bundle : bundles = item.getBundles()) {
                                Bitstream[] bitstreams;
                                for (Bitstream bit : bitstreams = bundle.getBitstreams()) {
                                    size += (float)bit.getSize();
                                }
                            }
                            items.add(item.getID());
                        }
                    }
                    finally {
                        if (iitems != null) {
                            iitems.close();
                        }
                    }
                }
                continue;
            }
            if (dso.getType() == 3) {
                Collection collection = (Collection)dso;
                ItemIterator iitems = collection.getItems();
                try {
                    while (iitems.hasNext()) {
                        Bundle[] bundles;
                        Item item = iitems.next();
                        for (Bundle bundle : bundles = item.getBundles()) {
                            Bitstream[] bitstreams;
                            for (Bitstream bit : bitstreams = bundle.getBitstreams()) {
                                size += (float)bit.getSize();
                            }
                        }
                        items.add(item.getID());
                    }
                    continue;
                }
                finally {
                    if (iitems != null) {
                        iitems.close();
                    }
                    continue;
                }
            }
            if (dso.getType() != 2) continue;
            Item item = (Item)dso;
            Bundle[] bundles = item.getBundles();
            for (DSpaceObject dSpaceObject : bundles) {
                Bitstream[] bitstreams;
                for (Bitstream bit : bitstreams = ((Bundle)dSpaceObject).getBitstreams()) {
                    size += (float)bit.getSize();
                }
            }
            items.add(item.getID());
        }
        String megaBytes = ConfigurationManager.getProperty("org.dspace.app.itemexport.max.size");
        if (megaBytes != null) {
            float maxSize = 0.0f;
            try {
                maxSize = Float.parseFloat(megaBytes);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (maxSize > 0.0f && (double)maxSize < (double)size / 1048576.0) {
                throw new Exception("The overall size of this export is too large.  Please contact your administrator for more information.");
            }
        }
        if (items.size() > 0) {
            Thread go = new Thread(){

                public void run() {
                    ItemIterator iitems = null;
                    try {
                        File dnDir;
                        Context context = new Context();
                        context.setIgnoreAuthorization(true);
                        iitems = new ItemIterator(context, items);
                        String fileName = ItemExport.assembleFileName("item", eperson, new Date());
                        String workDir = ItemExport.getExportWorkDirectory() + System.getProperty("file.separator") + fileName;
                        String downloadDir = ItemExport.getExportDownloadDirectory(eperson.getID());
                        File wkDir = new File(workDir);
                        if (!wkDir.exists()) {
                            wkDir.mkdirs();
                        }
                        if (!(dnDir = new File(downloadDir)).exists()) {
                            dnDir.mkdirs();
                        }
                        ItemExport.exportItem(context, iitems, workDir, 1);
                        ItemExport.zip(workDir, downloadDir + System.getProperty("file.separator") + fileName + ".zip");
                        ItemExport.emailSuccessMessage(eperson.getEmail(), ConfigurationManager.getProperty("mail.from.address"), additionalEmail, fileName + ".zip");
                        context.setIgnoreAuthorization(false);
                    }
                    catch (Exception e1) {
                        try {
                            ItemExport.emailErrorMessage(eperson.getEmail(), ConfigurationManager.getProperty("mail.from.address"), additionalEmail, e1.getMessage());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw new RuntimeException(e1);
                    }
                    finally {
                        if (iitems != null) {
                            iitems.close();
                        }
                    }
                }
            };
            go.isDaemon();
            go.start();
        }
    }

    public static String assembleFileName(String type, EPerson eperson, Date date) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MMM_dd");
        String downloadDir = ItemExport.getExportDownloadDirectory(eperson.getID());
        int count = 1;
        boolean exists = true;
        String fileName = null;
        while (exists) {
            fileName = type + "_export_" + sdf.format(date) + "_" + count + "_" + eperson.getID();
            exists = new File(downloadDir + System.getProperty("file.separator") + fileName + ".zip").exists();
            ++count;
        }
        return fileName;
    }

    public static String getExportDownloadDirectory(int ePersonID) throws Exception {
        String downloadDir = ConfigurationManager.getProperty("org.dspace.app.itemexport.download.dir");
        if (downloadDir == null) {
            throw new Exception("A dspace.cfg entry for 'org.dspace.app.itemexport.download.dir' does not exist.");
        }
        return downloadDir + System.getProperty("file.separator") + ePersonID;
    }

    public static String getExportWorkDirectory() throws Exception {
        String exportDir = ConfigurationManager.getProperty("org.dspace.app.itemexport.work.dir");
        if (exportDir == null) {
            throw new Exception("A dspace.cfg entry for 'org.dspace.app.itemexport.work.dir' does not exist.");
        }
        return exportDir;
    }

    public static InputStream getExportDownloadInputStream(String fileName, EPerson eperson) throws Exception {
        File file = new File(ItemExport.getExportDownloadDirectory(eperson.getID()) + System.getProperty("file.separator") + fileName);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        return null;
    }

    public static long getExportFileSize(String fileName) throws Exception {
        String strID = fileName.substring(fileName.lastIndexOf(95) + 1, fileName.lastIndexOf(46));
        File file = new File(ItemExport.getExportDownloadDirectory(Integer.parseInt(strID)) + System.getProperty("file.separator") + fileName);
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("The file " + ItemExport.getExportDownloadDirectory(Integer.parseInt(strID)) + System.getProperty("file.separator") + fileName + " does not exist.");
        }
        return file.length();
    }

    public static long getExportFileLastModified(String fileName) throws Exception {
        String strID = fileName.substring(fileName.lastIndexOf(95) + 1, fileName.lastIndexOf(46));
        File file = new File(ItemExport.getExportDownloadDirectory(Integer.parseInt(strID)) + System.getProperty("file.separator") + fileName);
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("The file " + ItemExport.getExportDownloadDirectory(Integer.parseInt(strID)) + System.getProperty("file.separator") + fileName + " does not exist.");
        }
        return file.lastModified();
    }

    public static boolean canDownload(Context context, String fileName) {
        EPerson eperson = context.getCurrentUser();
        if (eperson == null) {
            return false;
        }
        String strID = fileName.substring(fileName.lastIndexOf(95) + 1, fileName.lastIndexOf(46));
        try {
            if (Integer.parseInt(strID) == eperson.getID()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static List<String> getExportsAvailable(EPerson eperson) throws Exception {
        File downloadDir = new File(ItemExport.getExportDownloadDirectory(eperson.getID()));
        if (!downloadDir.exists() || !downloadDir.isDirectory()) {
            return null;
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String fileName : downloadDir.list()) {
            if (!fileName.contains("export") || !fileName.endsWith(".zip")) continue;
            fileNames.add(fileName);
        }
        if (fileNames.size() > 0) {
            return fileNames;
        }
        return null;
    }

    public static void deleteOldExportArchives(int epersonID) throws Exception {
        int hours = ConfigurationManager.getIntProperty("org.dspace.app.itemexport.life.span.hours");
        Calendar now = Calendar.getInstance();
        now.setTime(new Date());
        now.add(10, -hours);
        File downloadDir = new File(ItemExport.getExportDownloadDirectory(epersonID));
        if (downloadDir.exists()) {
            File[] files;
            for (File file : files = downloadDir.listFiles()) {
                if (file.lastModified() >= now.getTimeInMillis()) continue;
                file.delete();
            }
        }
    }

    public static void emailSuccessMessage(String toMail, String fromMail, String ccMail, String fileName) throws MessagingException {
        StringBuffer content = new StringBuffer();
        content.append("The item export you requested from the repositry is now ready for download.");
        content.append(System.getProperty("line.separator"));
        content.append(System.getProperty("line.separator"));
        content.append("You may download the compressed file using the following web address:");
        content.append(System.getProperty("line.separator"));
        content.append(ConfigurationManager.getProperty("dspace.url"));
        content.append("/exportdownload/");
        content.append(fileName);
        content.append(System.getProperty("line.separator"));
        content.append(System.getProperty("line.separator"));
        content.append("Tis file will remain available for at least ");
        content.append(ConfigurationManager.getProperty("org.dspace.app.itemexport.life.span.hours"));
        content.append(" hours.");
        content.append(System.getProperty("line.separator"));
        content.append(System.getProperty("line.separator"));
        content.append("Thank you");
        ItemExport.sendMessage(toMail, fromMail, ccMail, "Item export requested is ready for download", content);
    }

    public static void emailErrorMessage(String toMail, String fromMail, String ccMail, String error) throws MessagingException {
        StringBuffer content = new StringBuffer();
        content.append("The item export you requested was not completed.");
        content.append(System.getProperty("line.separator"));
        content.append(System.getProperty("line.separator"));
        content.append("For more infrmation you may contact your system administrator.");
        content.append(System.getProperty("line.separator"));
        content.append(System.getProperty("line.separator"));
        content.append("Error message received: ");
        content.append(error);
        content.append(System.getProperty("line.separator"));
        content.append(System.getProperty("line.separator"));
        content.append("Thank you");
        ItemExport.sendMessage(toMail, fromMail, ccMail, "Item export requested was not completed", content);
    }

    private static void sendMessage(String toMail, String fromMail, String ccMail, String subject, StringBuffer content) throws MessagingException {
        try {
            if (toMail == null || !toMail.contains("@")) {
                return;
            }
            String server = ConfigurationManager.getProperty("mail.server");
            Properties props = System.getProperties();
            props.put("mail.smtp.host", server);
            Session session = Session.getDefaultInstance((Properties)props, null);
            MimeMessage msg = new MimeMessage(session);
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(content.toString());
            multipart.addBodyPart((BodyPart)messageBodyPart);
            msg.setContent((Multipart)multipart);
            msg.setFrom((Address)new InternetAddress(fromMail));
            msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toMail));
            if (ccMail != null && ccMail.contains("@")) {
                msg.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(ccMail));
            }
            msg.setSentDate(new Date());
            msg.setSubject(subject);
            Transport.send((Message)msg);
        }
        catch (MessagingException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void zip(String strSource, String target) throws Exception {
        ZipOutputStream cpZipOutputStream = null;
        String tempFileName = target + "_tmp";
        File cpFile = new File(strSource);
        if (!cpFile.isFile() && !cpFile.isDirectory()) {
            return;
        }
        File targetFile = new File(tempFileName);
        if (!targetFile.exists()) {
            targetFile.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(tempFileName);
        cpZipOutputStream = new ZipOutputStream(fos);
        cpZipOutputStream.setLevel(9);
        ItemExport.zipFiles(cpFile, strSource, tempFileName, cpZipOutputStream);
        cpZipOutputStream.finish();
        cpZipOutputStream.close();
        ItemExport.deleteDirectory(cpFile);
        targetFile.renameTo(new File(target));
    }

    private static void zipFiles(File cpFile, String strSource, String strTarget, ZipOutputStream cpZipOutputStream) throws Exception {
        int DATA_BLOCK_SIZE = 2048;
        if (cpFile.isDirectory()) {
            File[] fList = cpFile.listFiles();
            for (int i = 0; i < fList.length; ++i) {
                ItemExport.zipFiles(fList[i], strSource, strTarget, cpZipOutputStream);
            }
        } else {
            int byteCount;
            if (cpFile.getAbsolutePath().equalsIgnoreCase(strTarget)) {
                return;
            }
            String strAbsPath = cpFile.getPath();
            String strZipEntryName = strAbsPath.substring(strSource.length() + 1, strAbsPath.length());
            FileInputStream cpFileInputStream = new FileInputStream(cpFile);
            ZipEntry cpZipEntry = new ZipEntry(strZipEntryName);
            cpZipOutputStream.putNextEntry(cpZipEntry);
            byte[] b = new byte[2048];
            while ((byteCount = cpFileInputStream.read(b, 0, 2048)) != -1) {
                cpZipOutputStream.write(b, 0, byteCount);
            }
            cpZipOutputStream.closeEntry();
        }
    }

    private static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    ItemExport.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        boolean pathDeleted = path.delete();
        return pathDeleted;
    }
}

