/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.core.ConfigurationManager;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

public class PDFFilter
extends MediaFilter {
    private static Logger log = Logger.getLogger(PDFFilter.class);

    public String getFilteredName(String oldFilename) {
        return oldFilename + ".txt";
    }

    public String getBundleName() {
        return "TEXT";
    }

    public String getFormatString() {
        return "Text";
    }

    public String getDescription() {
        return "Extracted text";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getDestinationStream(InputStream source) throws Exception {
        try {
            boolean useTemporaryFile = ConfigurationManager.getBooleanProperty("pdffilter.largepdfs", false);
            PDFTextStripper pts = new PDFTextStripper();
            PDDocument pdfDoc = null;
            OutputStreamWriter writer = null;
            File tempTextFile = null;
            ByteArrayOutputStream byteStream = null;
            if (useTemporaryFile) {
                tempTextFile = File.createTempFile("dspacepdfextract" + source.hashCode(), ".txt");
                tempTextFile.deleteOnExit();
                writer = new OutputStreamWriter(new FileOutputStream(tempTextFile));
            } else {
                byteStream = new ByteArrayOutputStream();
                writer = new OutputStreamWriter(byteStream);
            }
            try {
                pdfDoc = PDDocument.load((InputStream)source);
                pts.writeText(pdfDoc, (Writer)writer);
            }
            finally {
                try {
                    if (pdfDoc != null) {
                        pdfDoc.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error closing PDF file: " + e.getMessage()), (Throwable)e);
                }
                try {
                    ((Writer)writer).close();
                }
                catch (Exception e) {
                    log.error((Object)("Error closing temporary extract file: " + e.getMessage()), (Throwable)e);
                }
            }
            if (useTemporaryFile) {
                return new FileInputStream(tempTextFile);
            }
            byte[] bytes = byteStream.toByteArray();
            return new ByteArrayInputStream(bytes);
        }
        catch (OutOfMemoryError oome) {
            log.error((Object)("Error parsing PDF document " + oome.getMessage()), (Throwable)oome);
            if (!ConfigurationManager.getBooleanProperty("pdffilter.skiponmemoryexception", false)) {
                throw oome;
            }
            return null;
        }
    }
}

